/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;

@Rule(key="S6868")
public class CommandExecutionCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Remove the command execution permission for this role.";
    private static final List<String> SENSITIVE_KINDS = List.of("Role", "ClusterRole");

    @Override
    boolean shouldVisitWholeDocument() {
        return true;
    }

    @Override
    void registerObjectCheck() {
        this.register(SENSITIVE_KINDS, (BlockObject document) -> document.blocks("rules").filter(CommandExecutionCheck::ruleContainsSensitiveVerb).filter(CommandExecutionCheck::ruleContainsSensitiveResource).forEach(rule -> rule.attribute("resources").reportOnKey(MESSAGE)));
    }

    private static boolean ruleContainsSensitiveVerb(BlockObject rule) {
        return CommandExecutionCheck.containsSensitiveItemOrWildCard(rule, "verbs", "create");
    }

    private static boolean ruleContainsSensitiveResource(BlockObject rule) {
        return CommandExecutionCheck.containsSensitiveItemOrWildCard(rule, "resources", "pods/exec");
    }

    private static boolean containsSensitiveItemOrWildCard(BlockObject rule, String listKey, String sensitiveItem) {
        Predicate<YamlTree> verbsPredicate = TreePredicates.isEqualTo(sensitiveItem).or(TreePredicates.isEqualTo("*"));
        return rule.list(listKey).getItemIf(verbsPredicate).findAny().isPresent();
    }
}

