/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;
import org.sonar.iac.kubernetes.visitors.KubernetesCheckContext;

public abstract class AbstractLimitsCheck
extends AbstractKubernetesObjectCheck {
    protected static final String KIND_POD = "Pod";
    protected static final List<String> KIND_WITH_TEMPLATE = List.of("DaemonSet", "Deployment", "Job", "ReplicaSet", "ReplicationController", "StatefulSet", "CronJob");

    @Override
    void registerObjectCheck() {
        this.register(KIND_POD, (BlockObject pod) -> pod.blocks("containers").forEach(this::reportMissingLimit));
        this.register(KIND_WITH_TEMPLATE, (BlockObject obj) -> obj.block("template").block("spec").blocks("containers").forEach(this::reportMissingLimit));
    }

    void reportMissingLimit(BlockObject container) {
        if (((KubernetesCheckContext)container.ctx).projectContext().hasNoLimitRange()) {
            container.block("resources").block("limits").attribute(this.getLimitAttributeKey()).reportIfAbsent(AbstractLimitsCheck.getFirstChildElement(container), this.getMessage()).reportIfValue(TreePredicates.isSet().negate(), this.getMessage());
        }
    }

    @Nullable
    static HasTextRange getFirstChildElement(BlockObject blockObject) {
        if (blockObject.tree != null) {
            return ((MappingTree)blockObject.tree).elements().get(0).key();
        }
        return null;
    }

    abstract String getLimitAttributeKey();

    abstract String getMessage();
}

