/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutableHelper {
    private static final int BUFFER_SIZE = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableHelper.class);

    private ExecutableHelper() {
    }

    public static String extractFromClasspath(File workDir, String executable) throws IOException {
        File destination = new File(workDir, executable);
        byte[] executableData = ExecutableHelper.getBytesFromResource(executable);
        if (!ExecutableHelper.fileContentMatches(destination, executableData)) {
            Files.write(destination.toPath(), executableData, new OpenOption[0]);
            if (!System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(destination.toPath(), new LinkOption[0]);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(destination.toPath(), permissions);
            }
        }
        return destination.getAbsolutePath();
    }

    public static void readProcessErrorOutput(Process process) {
        try (InputStream errorOutput = process.getErrorStream();){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorOutput, StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                LOG.debug("[{}] {}", (Object)"sonar-helm-for-iac", (Object)line);
            }
        }
        catch (IOException e) {
            LOG.debug("Error reading process error output for {}", (Object)"sonar-helm-for-iac", (Object)e);
        }
    }

    @CheckForNull
    public static byte[] readProcessOutput(Process process) {
        byte[] byArray;
        block8: {
            InputStream output = process.getInputStream();
            try {
                byArray = output.readAllBytes();
                if (output == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug("Error reading process output for {}", (Object)"sonar-helm-for-iac", (Object)e);
                    return null;
                }
            }
            output.close();
        }
        return byArray;
    }

    static boolean fileContentMatches(File destination, byte[] expectedContent) throws IOException {
        if (!destination.exists()) {
            return false;
        }
        byte[] actualContent = Files.readAllBytes(destination.toPath());
        return Arrays.equals(actualContent, expectedContent);
    }

    static byte[] getBytesFromResource(String executable) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = ExecutableHelper.class.getClassLoader().getResourceAsStream(executable);){
            if (in == null) {
                throw new IllegalStateException(executable + " binary not found on class path");
            }
            ExecutableHelper.copy(in, out);
        }
        return out.toByteArray();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }
}

