/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm.tree.impl;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.impl.TextPointer;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.helm.tree.api.Location;

public class LocationImpl
implements Location {
    private static final String NEW_LINE = "\\n\\r\\u2028\\u2029";
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<lineContent>[^\\n\\r\\u2028\\u2029]*+)(?<newLine>\\z|\\r\\n|[\\n\\r\\u2028\\u2029])");
    private static final String LINE_CONTENT_GROUP = "lineContent";
    private static final String NEW_LINE_GROUP = "newLine";
    private final int position;
    private final int length;

    public LocationImpl(int position, int length) {
        this.position = position;
        this.length = length;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationImpl location = (LocationImpl)o;
        return this.position == location.position && this.length == location.length;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.length);
    }

    public String toString() {
        return "LocationImpl{position=" + this.position + ", length=" + this.length + "}";
    }

    public static Location fromTextRange(TextRange textRange, String text) {
        int startOffset = LocationImpl.toPosition(textRange.start(), text);
        int endOffset = LocationImpl.toPosition(textRange.end(), text);
        return new LocationImpl(startOffset, endOffset - startOffset);
    }

    private static int toPosition(TextPointer textPointer, String text) {
        Matcher matcher = LINE_PATTERN.matcher(text);
        int positionCounter = 0;
        positionCounter = LocationImpl.sumLineLengthsUntilLine(textPointer.line(), matcher);
        if (positionCounter == text.length()) {
            String message = String.format("Unable to calculate position from TextRange, line %s doesn't exist", textPointer.line());
            throw new IllegalArgumentException(message);
        }
        LocationImpl.moveToNextLine(matcher);
        String lineContent = matcher.group(LINE_CONTENT_GROUP);
        String newLine = matcher.group(NEW_LINE_GROUP);
        int newLineLength = newLine.length();
        if (textPointer.lineOffset() > lineContent.length() + newLineLength) {
            String message = String.format("Unable to calculate position from TextRange, line offset %s is too big", textPointer.lineOffset());
            throw new IllegalArgumentException(message);
        }
        return positionCounter + textPointer.lineOffset();
    }

    private static int sumLineLengthsUntilLine(int lineNumber, Matcher matcher) {
        int positionCounter = 0;
        for (int i = 1; i < lineNumber; ++i) {
            if (!matcher.find()) {
                String message = String.format("Unable to calculate position from TextRange, line number %s is too big", lineNumber);
                throw new IllegalArgumentException(message);
            }
            String lineContent = matcher.group(LINE_CONTENT_GROUP);
            String newLine = matcher.group(NEW_LINE_GROUP);
            int newLineLength = newLine.length();
            positionCounter = positionCounter + lineContent.length() + newLineLength;
        }
        return positionCounter;
    }

    private static void moveToNextLine(Matcher matcher) {
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unable to calculate position from TextRange, no next line");
        }
    }

    @Override
    public TextRange toTextRange(String sourceCode) {
        TextPointer start = LocationImpl.toTextPointer(this.position, sourceCode);
        TextPointer end = LocationImpl.toTextPointer(this.position + this.length, sourceCode);
        return new TextRange(start, end);
    }

    private static TextPointer toTextPointer(int position, String sourceCode) {
        Matcher matcher = LINE_PATTERN.matcher(sourceCode);
        int lineCounter = 1;
        int positionCounter = 0;
        String lineContent = "";
        String newLine = "";
        boolean foundLineNumber = false;
        while (matcher.find()) {
            lineContent = matcher.group(LINE_CONTENT_GROUP);
            newLine = matcher.group(NEW_LINE_GROUP);
            if (lineContent.isEmpty() && newLine.isEmpty()) break;
            int newPositionCounter = positionCounter + lineContent.length() + newLine.length();
            if (newPositionCounter > position) {
                foundLineNumber = true;
                break;
            }
            if (newPositionCounter == position) {
                if (!newLine.isEmpty()) {
                    ++lineCounter;
                    positionCounter = newPositionCounter;
                }
                foundLineNumber = true;
                break;
            }
            ++lineCounter;
            positionCounter = newPositionCounter;
        }
        if (!foundLineNumber) {
            String message = String.format("The position %s is too big for text length %s", position, sourceCode.length());
            throw new IllegalArgumentException(message);
        }
        return new TextPointer(lineCounter, position - positionCounter);
    }
}

