/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public final class LineNumberCommentRemover {
    private static final String NEW_LINE = "\\n\\r\\u2028\\u2029";
    private static final Set<Character> NEW_LINES_CHARACTERS = Set.of(Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\u2028'), Character.valueOf('\u2029'));
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<lineContent>[^\\n\\r\\u2028\\u2029]*+)(?<newLine>\\r\\n|[\\n\\r\\u2028\\u2029])");
    private static final Pattern CONTAINS_LINE_NUMBER_OR_RANGE = Pattern.compile("#(?<rangeStart>\\d++)(:(?<rangeEnd>\\d++))?( ?#\\d++:?\\d*+)*+$");

    private LineNumberCommentRemover() {
    }

    public static String cleanSource(String source, HelmInputFileContext inputFileContext) {
        LineAndComment lineAndComment;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = LINE_PATTERN.matcher(source);
        int lastIndex = 0;
        int lineCounter = 1;
        while (matcher.find()) {
            String lineContent = matcher.group("lineContent");
            lineAndComment = LineNumberCommentRemover.toLineAndComment(lineContent);
            if (lineAndComment.contentWithoutComment.isBlank()) continue;
            lineAndComment.addToLocationShifter(inputFileContext, lineCounter);
            sb.append(lineAndComment.contentWithoutComment);
            sb.append(matcher.group("newLine"));
            lastIndex = matcher.end();
            ++lineCounter;
        }
        ++lineCounter;
        String lastLine = source.substring(lastIndex);
        lineAndComment = LineNumberCommentRemover.toLineAndComment(lastLine);
        if (!lineAndComment.contentWithoutComment.isBlank()) {
            sb.append(lineAndComment.contentWithoutComment);
            lineAndComment.addToLocationShifter(inputFileContext, lineCounter);
        }
        return LineNumberCommentRemover.removeNewLinesAtTheEnd(sb.toString());
    }

    private static String removeNewLinesAtTheEnd(String input) {
        int index;
        for (index = input.length() - 1; index >= 0 && NEW_LINES_CHARACTERS.contains(Character.valueOf(input.charAt(index))); --index) {
        }
        return input.substring(0, index + 1);
    }

    private static LineAndComment toLineAndComment(String lineContent) {
        Matcher commentMatcher = CONTAINS_LINE_NUMBER_OR_RANGE.matcher(lineContent);
        if (commentMatcher.find()) {
            String comment = commentMatcher.group();
            int endIndex = lineContent.indexOf(comment);
            String lineContentWithoutComment = lineContent.substring(0, Math.max(endIndex - 1, 0));
            int lineCommentRangeStart = Integer.parseInt(commentMatcher.group("rangeStart"));
            Integer lineCommentRangeEnd = Optional.ofNullable(commentMatcher.group("rangeEnd")).map(Integer::parseInt).orElse(lineCommentRangeStart);
            return new LineAndComment(lineContentWithoutComment, lineCommentRangeStart, lineCommentRangeEnd);
        }
        return new LineAndComment(lineContent);
    }

    private static class LineAndComment {
        private final String contentWithoutComment;
        private final Integer lineCommentRangeStart;
        private final Integer lineCommentRangeEnd;

        public LineAndComment(String contentWithoutComment) {
            this.contentWithoutComment = contentWithoutComment;
            this.lineCommentRangeStart = null;
            this.lineCommentRangeEnd = null;
        }

        public LineAndComment(String contentWithoutComment, Integer lineCommentRangeStart, Integer lineCommentRangeEnd) {
            this.contentWithoutComment = contentWithoutComment;
            this.lineCommentRangeStart = lineCommentRangeStart;
            this.lineCommentRangeEnd = lineCommentRangeEnd;
        }

        public void addToLocationShifter(HelmInputFileContext inputFileContext, int lineCounter) {
            if (this.lineCommentRangeStart != null && this.lineCommentRangeEnd != null) {
                LocationShifter.addShiftedLine(inputFileContext, lineCounter, this.lineCommentRangeStart, this.lineCommentRangeEnd);
            }
        }
    }
}

