/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.Collection;
import java.util.function.Predicate;

public final class StringPredicate {
    private StringPredicate() {
    }

    public static Predicate<String> startsWithIgnoreQuotes(String value) {
        return str -> StringPredicate.stripQuotes(str).startsWith(value);
    }

    public static Predicate<String> equalsIgnoreQuotes(String value) {
        return str -> StringPredicate.stripQuotes(str).equals(value);
    }

    public static Predicate<String> containsIgnoreQuotes(Collection<String> values) {
        return str -> values.contains(StringPredicate.stripQuotes(str));
    }

    static String stripQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

