/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks.utils;

import java.util.function.Predicate;
import org.sonar.iac.docker.checks.utils.StringPredicate;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.ExpandableStringLiteral;

public class FlagNoSpaceArgumentPredicate
implements Predicate<ArgumentResolution> {
    private final String flag;

    public FlagNoSpaceArgumentPredicate(String flag) {
        this.flag = flag;
    }

    @Override
    public boolean test(ArgumentResolution resolution) {
        String resolvedValue = StringPredicate.stripQuotes(resolution.value());
        if (resolvedValue.startsWith(this.flag)) {
            if (resolvedValue.length() > this.flag.length()) {
                return true;
            }
            if (resolution.argument().expressions().size() > 1) {
                return true;
            }
            if (resolution.argument().expressions().get(0).is(DockerTree.Kind.EXPANDABLE_STRING_LITERAL)) {
                ExpandableStringLiteral expression = (ExpandableStringLiteral)resolution.argument().expressions().get(0);
                return expression.expressions().size() > 1;
            }
        }
        return false;
    }
}

