/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.object;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.yaml.object.AttributeObject;
import org.sonar.iac.common.yaml.object.ListObject;
import org.sonar.iac.common.yaml.object.YamlObject;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class BlockObject
extends YamlObject<MappingTree> {
    protected BlockObject(CheckContext ctx, @Nullable MappingTree tree, String key, YamlObject.Status status) {
        super(ctx, tree, key, status);
    }

    public static BlockObject fromPresent(CheckContext ctx, YamlTree tree, String key) {
        if (tree instanceof MappingTree) {
            MappingTree mappingTree = (MappingTree)tree;
            return new BlockObject(ctx, mappingTree, key, YamlObject.Status.PRESENT);
        }
        return new BlockObject(ctx, null, key, YamlObject.Status.UNKNOWN);
    }

    public static BlockObject fromAbsent(CheckContext ctx, String key) {
        return new BlockObject(ctx, null, key, YamlObject.Status.ABSENT);
    }

    public Stream<BlockObject> blocks(String key) {
        return Optional.ofNullable((MappingTree)this.tree).flatMap(tree -> PropertyUtils.value(tree, key, SequenceTree.class)).map(sequence -> sequence.elements().stream().map(block -> BlockObject.fromPresent(this.ctx, block, key))).orElse(Stream.empty());
    }

    public BlockObject block(String key) {
        return Optional.ofNullable((MappingTree)this.tree).flatMap(tree -> PropertyUtils.get(tree, key, TupleTree.class)).map(tuple -> BlockObject.fromPresent(this.ctx, tuple.value(), key)).orElse(BlockObject.fromAbsent(this.ctx, key));
    }

    public AttributeObject attribute(String key) {
        return Optional.ofNullable((MappingTree)this.tree).flatMap(tree -> PropertyUtils.get(tree, key, TupleTree.class)).map(attribute -> AttributeObject.fromPresent(this.ctx, attribute, key)).orElse(AttributeObject.fromAbsent(this.ctx, key));
    }

    public ListObject list(String key) {
        return Optional.ofNullable((MappingTree)this.tree).flatMap(tree -> PropertyUtils.get(tree, key, TupleTree.class)).map(attribute -> ListObject.fromPresent(this.ctx, attribute, key, null)).orElse(ListObject.fromAbsent(this.ctx, key));
    }
}

