/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.object;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.yaml.object.YamlObject;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class AttributeObject
extends YamlObject<TupleTree> {
    AttributeObject(CheckContext ctx, @Nullable TupleTree tree, String key, YamlObject.Status status) {
        super(ctx, tree, key, status);
    }

    public static AttributeObject fromPresent(CheckContext ctx, YamlTree tree, String key) {
        if (tree instanceof TupleTree) {
            TupleTree tupleTree = (TupleTree)tree;
            return new AttributeObject(ctx, tupleTree, key, YamlObject.Status.PRESENT);
        }
        return new AttributeObject(ctx, null, key, YamlObject.Status.UNKNOWN);
    }

    public static AttributeObject fromAbsent(CheckContext ctx, String key) {
        return new AttributeObject(ctx, null, key, YamlObject.Status.ABSENT);
    }

    public AttributeObject reportIfValue(Predicate<YamlTree> predicate, String message) {
        if (this.tree != null && predicate.test(((TupleTree)this.tree).value())) {
            this.ctx.reportIssue(((TupleTree)this.tree).value(), message);
        }
        return this;
    }

    public AttributeObject reportIfAbsent(@Nullable HasTextRange hasTextRange, String message) {
        if (this.status == YamlObject.Status.ABSENT && hasTextRange != null) {
            this.report(hasTextRange.textRange(), message);
        }
        return this;
    }

    private AttributeObject report(@Nullable TextRange textRange, String message) {
        if (textRange != null) {
            this.ctx.reportIssue(textRange, message);
        }
        return this;
    }

    public AttributeObject reportOnKey(String message) {
        if (this.tree != null) {
            this.report(((TupleTree)this.tree).key().textRange(), message);
        }
        return this;
    }

    public AttributeObject reportOnValue(String message) {
        if (this.tree != null) {
            this.report(((TupleTree)this.tree).value().toHighlight(), message);
        }
        return this;
    }
}

