/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.ArrayList;
import java.util.List;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.yaml.IacYamlConverter;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.FileTreeImpl;
import org.sonar.iac.common.yaml.tree.MappingTreeImpl;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.ScalarTreeImpl;
import org.sonar.iac.common.yaml.tree.SequenceTreeImpl;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.TupleTreeImpl;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class YamlConverter
implements IacYamlConverter<FileTree, YamlTree> {
    @Override
    public FileTree convertFile(List<Node> nodes) {
        if (nodes.isEmpty()) {
            throw new ParseException("Unexpected empty nodes list while converting file", null, null);
        }
        Node fileNode = nodes.get(0);
        Node lastNode = ListUtils.getLast(nodes);
        YamlTreeMetadata metadata = YamlTreeMetadata.builder().fromNodes(fileNode, lastNode).withTag("FILE").withComments(fileNode.getEndComments()).build();
        List<YamlTree> documents = nodes.stream().map(this::convert).toList();
        return new FileTreeImpl(documents, metadata);
    }

    @Override
    public YamlTree convertMapping(MappingNode mappingNode) {
        ArrayList<TupleTree> elements = new ArrayList<TupleTree>();
        for (NodeTuple elementNode : mappingNode.getValue()) {
            elements.add(this.convertTuple(elementNode));
        }
        return new MappingTreeImpl(elements, YamlTreeMetadata.fromNode(mappingNode));
    }

    @Override
    public YamlTree convertScalar(ScalarNode scalarNode) {
        return new ScalarTreeImpl(scalarNode.getValue(), YamlConverter.scalarStyleConvert(scalarNode.getScalarStyle()), YamlTreeMetadata.fromNode(scalarNode));
    }

    @Override
    public TupleTree convertTuple(NodeTuple tuple) {
        YamlTree key = (YamlTree)this.convert(tuple.getKeyNode());
        YamlTree value = (YamlTree)this.convert(tuple.getValueNode());
        return new TupleTreeImpl(key, value, YamlTreeMetadata.fromNodes("TUPLE", tuple.getKeyNode(), tuple.getValueNode()));
    }

    @Override
    public YamlTree convertSequence(SequenceNode sequenceNode) {
        ArrayList<YamlTree> elements = new ArrayList<YamlTree>();
        for (Node elementNode : sequenceNode.getValue()) {
            elements.add((YamlTree)this.convert(elementNode));
        }
        return new SequenceTreeImpl(elements, YamlTreeMetadata.fromNode(sequenceNode));
    }

    protected static ScalarTree.Style scalarStyleConvert(ScalarStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ScalarStyle.DOUBLE_QUOTED -> ScalarTree.Style.DOUBLE_QUOTED;
            case ScalarStyle.SINGLE_QUOTED -> ScalarTree.Style.SINGLE_QUOTED;
            case ScalarStyle.LITERAL -> ScalarTree.Style.LITERAL;
            case ScalarStyle.FOLDED -> ScalarTree.Style.FOLDED;
            case ScalarStyle.PLAIN -> ScalarTree.Style.PLAIN;
        };
    }
}

