/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.ScannerImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;

public interface IacYamlParser<T extends Tree>
extends TreeParser<T> {
    public T convert(List<Node> var1);

    @Override
    default public T parse(String source, @Nullable InputFileContext inputFileContext) {
        LoadSettings settings = LoadSettings.builder().setParseComments(IacYamlParser.shouldParseComments(inputFileContext)).build();
        StreamReader reader = new StreamReader(settings, source);
        ScannerImpl scanner = new ScannerImpl(settings, reader);
        ParserImpl parser = new ParserImpl(settings, scanner);
        Composer composer = new Composer(settings, parser);
        List<Node> nodes = IacYamlParser.composerNodes(composer);
        return this.convert(nodes);
    }

    private static List<Node> composerNodes(Composer composer) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (composer.hasNext()) {
            nodes.add(composer.next());
        }
        return nodes;
    }

    private static boolean shouldParseComments(@Nullable InputFileContext inputFileContext) {
        return inputFileContext == null || !inputFileContext.inputFile.filename().toLowerCase(Locale.ROOT).endsWith(".json");
    }
}

