/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.List;
import org.snakeyaml.engine.v2.exceptions.ParserException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.sonar.iac.common.api.tree.Tree;

public interface IacYamlConverter<T extends Tree, S> {
    default public S convert(Node node) {
        if (node.isRecursive()) {
            throw new ParserException("Recursive node found", node.getStartMark());
        }
        if (node instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)node;
            return this.convertMapping(mappingNode);
        }
        if (node instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)node;
            return this.convertScalar(scalarNode);
        }
        if (node instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)node;
            return this.convertSequence(sequenceNode);
        }
        throw new ParserException("Unexpected node type: " + node.getClass(), node.getStartMark());
    }

    public T convertFile(List<Node> var1);

    public S convertMapping(MappingNode var1);

    public S convertScalar(ScalarNode var1);

    public S convertTuple(NodeTuple var1);

    public S convertSequence(SequenceNode var1);
}

