/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.visitors.TreeContext;

public class InputFileContext
extends TreeContext {
    private static final Logger LOG = LoggerFactory.getLogger(InputFileContext.class);
    private static final String PARSING_ERROR_RULE_KEY = "S2260";
    public final SensorContext sensorContext;
    public final InputFile inputFile;
    private final Set<Integer> raisedIssues = new HashSet<Integer>();

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
    }

    public void reportIssue(RuleKey ruleKey, @Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
        if (this.raisedIssues.add(InputFileContext.issueHash(ruleKey, textRange, secondaryLocations))) {
            NewIssue issue = this.sensorContext.newIssue();
            NewIssueLocation issueLocation = issue.newLocation().on(this.inputFile).message(message);
            if (textRange != null && TextRanges.isValidAndNotEmpty(textRange)) {
                issueLocation.at(this.toInputFileRange(this.inputFile, textRange));
            }
            issue.forRule(ruleKey).at(issueLocation);
            secondaryLocations.stream().filter(secondary -> secondary != null && TextRanges.isValidAndNotEmpty(secondary.textRange)).forEach(secondary -> {
                NewIssueLocation newIssueLocation = this.newLocation(issue, (SecondaryLocation)secondary);
                if (newIssueLocation != null) {
                    issue.addLocation(newIssueLocation);
                }
            });
            issue.save();
        }
    }

    public void reportParseError(String repositoryKey, @Nullable TextPointer location) {
        this.reportAnalysisError("Unable to parse file: " + this.inputFile, location);
        RuleKey parsingErrorRuleKey = RuleKey.of(repositoryKey, PARSING_ERROR_RULE_KEY);
        if (this.sensorContext.activeRules().find(parsingErrorRuleKey) == null) {
            return;
        }
        NewIssue parseError = this.sensorContext.newIssue();
        NewIssueLocation parseErrorLocation = parseError.newLocation().on(this.inputFile).message("A parsing error occurred in this file.");
        Optional.ofNullable(location).map(TextPointer::line).map(this.inputFile::selectLine).ifPresent(parseErrorLocation::at);
        parseError.forRule(parsingErrorRuleKey).at(parseErrorLocation).save();
    }

    public void reportAnalysisError(String message, @Nullable TextPointer location) {
        NewAnalysisError error = this.sensorContext.newAnalysisError();
        error.message(message).onFile(this.inputFile);
        if (location != null) {
            TextPointer pointerLocation = null;
            try {
                pointerLocation = this.inputFile.newPointer(location.line(), location.lineOffset());
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Error when creating valid line offset of pointer, fallback to beginning of the file.", e);
                pointerLocation = this.inputFile.newPointer(1, 0);
            }
            error.at(pointerLocation);
        }
        error.save();
    }

    @CheckForNull
    private NewIssueLocation newLocation(NewIssue newIssue, SecondaryLocation secondaryLocation) {
        InputFile fileToRaiseOn = this.retrieveFileToRaiseOn(secondaryLocation);
        if (fileToRaiseOn != null) {
            return newIssue.newLocation().on(fileToRaiseOn).at(this.toInputFileRange(fileToRaiseOn, secondaryLocation.textRange)).message(secondaryLocation.message);
        }
        return null;
    }

    @CheckForNull
    public InputFile retrieveFileToRaiseOn(SecondaryLocation secondaryLocation) {
        if (secondaryLocation.filePath == null) {
            return this.inputFile;
        }
        return this.sensorContext.fileSystem().inputFile(this.sensorContext.fileSystem().predicates().is(new File(secondaryLocation.filePath)));
    }

    public TextPointer newPointer(int line, int lineOffset) {
        try {
            return this.inputFile.newPointer(line, lineOffset);
        }
        catch (IllegalArgumentException e) {
            String message = "Unable to create new pointer for %s position %s:%s".formatted(this.inputFile, line, lineOffset);
            LOG.warn(message, e);
            if (IacSensor.isFailFast(this.sensorContext)) {
                throw new IllegalStateException(message, e);
            }
            return this.inputFile.newPointer(1, 0);
        }
    }

    private org.sonar.api.batch.fs.TextRange toInputFileRange(InputFile inputFile, TextRange textRange) {
        try {
            return inputFile.newRange(textRange.start().line(), textRange.start().lineOffset(), textRange.end().line(), textRange.end().lineOffset());
        }
        catch (IllegalArgumentException e) {
            String message = "Unable to create new range for %s and range %s".formatted(inputFile, textRange);
            LOG.warn(message, e);
            if (IacSensor.isFailFast(this.sensorContext)) {
                throw new IllegalStateException(message, e);
            }
            return inputFile.newRange(1, 0, 1, 1);
        }
    }

    private static int issueHash(RuleKey ruleKey, @Nullable TextRange textRange, List<SecondaryLocation> secondaryLocations) {
        return Objects.hash(ruleKey, textRange, secondaryLocations);
    }
}

