/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.impl.TextPointer;

public class TextRange {
    private static final String NEW_LINE = "\\n\\r\\u2028\\u2029";
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<lineContent>[^\\n\\r\\u2028\\u2029]*+)(?<newLine>\\z|\\r\\n|[\\n\\r\\u2028\\u2029])");
    private final TextPointer start;
    private final TextPointer end;

    public TextRange(TextPointer start, TextPointer end) {
        this.start = start;
        this.end = end;
    }

    public TextPointer start() {
        return this.start;
    }

    public TextPointer end() {
        return this.end;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TextRange otherRange = (TextRange)other;
        return Objects.equals(this.start, otherRange.start) && Objects.equals(this.end, otherRange.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start.line() + ":" + this.start.lineOffset() + "/" + this.end.line() + ":" + this.end.lineOffset() + "]";
    }

    public TextRange trimEndToText(String content) {
        String lineContent;
        Matcher matcher = LINE_PATTERN.matcher(content);
        int lineCounter = 1;
        boolean foundEndLine = false;
        String previousNewLine = "";
        while (matcher.find()) {
            lineContent = matcher.group("lineContent");
            String newLine = matcher.group("newLine");
            if (lineContent.isEmpty() && newLine.isEmpty()) {
                if (lineCounter != this.end.line() || previousNewLine.isEmpty()) break;
                foundEndLine = true;
                break;
            }
            if (lineCounter == this.end.line()) {
                foundEndLine = true;
                break;
            }
            ++lineCounter;
            previousNewLine = newLine;
        }
        if (!foundEndLine) {
            String message = String.format("The code contains %s lines, but end text range line is %s", lineCounter, this.end().line());
            throw new IllegalArgumentException(message);
        }
        lineContent = matcher.group("lineContent");
        if (this.end.lineOffset() >= lineContent.length()) {
            return new TextRange(this.start, new TextPointer(this.end().line(), lineContent.length()));
        }
        return this;
    }
}

