/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common;

import java.util.Arrays;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public class ConfigurationLanguage
extends AbstractLanguage {
    private final String fileSuffixesKey;
    private final String defaultFileSuffixes;
    private final Configuration configuration;

    public ConfigurationLanguage(String key, String name, Configuration configuration, String fileSuffixesKey, String defaultSuffixes) {
        super(key, name);
        this.configuration = configuration;
        this.fileSuffixesKey = fileSuffixesKey;
        this.defaultFileSuffixes = defaultSuffixes;
    }

    @Override
    public String[] getFileSuffixes() {
        String[] suffixes = (String[])Arrays.stream(this.configuration.getStringArray(this.fileSuffixesKey)).filter(s -> !s.trim().isEmpty()).toArray(String[]::new);
        if (suffixes.length > 0) {
            return suffixes;
        }
        return this.defaultFileSuffixes.split(",");
    }

    @Override
    public boolean publishAllFiles() {
        return false;
    }
}

