/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6303")
public class DisabledDBEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE_RDS_DB_INSTANCE = "Make sure that using unencrypted RDS DB Instances is safe here.";
    private static final String MESSAGE_RDS_CLUSTER = "Make sure that using an unencrypted RDS DB Cluster is safe here.";
    private static final String MESSAGE_RDS_DB_GLOBAL_CLUSTER = "Make sure that using an unencrypted RDS DB GlobalCluster is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"StorageEncrypted\" disables databases encryption. Make sure it is safe here.";
    private static final String SECONDARY_MESSAGE = "Related RDS DBInstance";
    private static final List<String> EXCLUDE_AURORA_ATTRIBUTE = List.of("aurora", "aurora-mysql", "aurora-postgresql");
    private static final String KEY_STORAGE_ENCRYPTED = "StorageEncrypted";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::RDS::DBCluster")) {
            DisabledDBEncryptionCheck.checkForDBClusterProperties(ctx, resource);
        } else if (resource.isType("AWS::RDS::GlobalCluster")) {
            DisabledDBEncryptionCheck.checkForGlobalClusterProperties(ctx, resource);
        } else if (resource.isType("AWS::RDS::DBInstance")) {
            if (PropertyUtils.get((Tree)resource.properties(), "Engine").stream().anyMatch(engine -> TextUtils.matchesValue(engine.value(), EXCLUDE_AURORA_ATTRIBUTE::contains).isTrue())) {
                return;
            }
            DisabledDBEncryptionCheck.checkStorageEncrypted(ctx, resource, MESSAGE_RDS_DB_INSTANCE);
        }
    }

    private static void checkForGlobalClusterProperties(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (PropertyUtils.get((Tree)resource.properties(), "SourceDBClusterIdentifier").isPresent()) {
            return;
        }
        DisabledDBEncryptionCheck.checkStorageEncrypted(ctx, resource, MESSAGE_RDS_DB_GLOBAL_CLUSTER);
    }

    private static void checkForDBClusterProperties(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (PropertyUtils.get((Tree)resource.properties(), "SourceDBClusterIdentifier").isPresent() || PropertyUtils.get((Tree)resource.properties(), "SnapshotIdentifier").isPresent()) {
            return;
        }
        DisabledDBEncryptionCheck.checkStorageEncrypted(ctx, resource, MESSAGE_RDS_CLUSTER);
    }

    private static void checkStorageEncrypted(CheckContext ctx, AbstractResourceCheck.Resource resource, String message) {
        Optional<PropertyTree> maybeEncryption = PropertyUtils.get((Tree)resource.properties(), KEY_STORAGE_ENCRYPTED);
        maybeEncryption.ifPresentOrElse(encryption -> {
            if (TextUtils.isValueFalse(encryption.value())) {
                ctx.reportIssue((HasTextRange)encryption.key(), message, new SecondaryLocation(resource.type(), SECONDARY_MESSAGE));
            }
        }, () -> ctx.reportIssue(resource.type(), OMITTING_MESSAGE));
    }
}

