/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.symbols.Symbol;
import org.sonar.iac.arm.symbols.SymbolTable;
import org.sonar.iac.arm.symbols.Usage;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.HasIdentifier;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Parameter;
import org.sonar.iac.arm.tree.api.ParameterDeclaration;
import org.sonar.iac.arm.tree.api.Variable;
import org.sonar.iac.arm.tree.api.VariableDeclaration;
import org.sonar.iac.arm.tree.api.bicep.Declaration;
import org.sonar.iac.arm.tree.impl.json.IdentifierImpl;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

public class ArmSymbolVisitor
extends TreeVisitor<InputFileContext> {
    private static final Pattern ASSIGNED_IDENTITIES_PATTERN = Pattern.compile("(?U)variables\\('(?<variableName>[\\p{L}_]\\w*)'\\)");
    private final List<TreeVisitor.ConsumerFilter<InputFileContext, ?>> consumersAfter = new ArrayList();
    private SymbolTable currentSymbolTable = new SymbolTable();

    public ArmSymbolVisitor() {
        this.register(File.class, (ctx, file) -> this.visitFile((File)file));
        this.register(VariableDeclaration.class, (ctx, variableDeclaration) -> this.visitDeclaration((Declaration)variableDeclaration));
        this.register(ParameterDeclaration.class, (ctx, parameterDeclaration) -> this.visitDeclaration((Declaration)parameterDeclaration));
        this.registerAfter(Variable.class, (ctx, variable) -> this.visitAccessUsage((HasIdentifier)variable));
        this.registerAfter(Parameter.class, (ctx, parameter) -> this.visitAccessUsage((HasIdentifier)parameter));
        this.registerAfter(IdentifierImpl.class, (ctx, identifier) -> this.visitIdentifierJson((IdentifierImpl)identifier));
    }

    @Override
    protected void after(InputFileContext ctx, @Nullable Tree node) {
        if (node != null) {
            ctx.enter(node);
            for (TreeVisitor.ConsumerFilter<InputFileContext, ?> consumer : this.consumersAfter) {
                consumer.accept(ctx, node);
            }
            node.children().forEach(child -> this.after(ctx, (Tree)child));
            ctx.leave();
        }
    }

    public final <T extends Tree> void registerAfter(Class<T> cls, BiConsumer<InputFileContext, T> visitor) {
        this.consumersAfter.add(new TreeVisitor.ConsumerFilter<InputFileContext, T>(cls, visitor));
    }

    void visitFile(File file) {
        this.currentSymbolTable = new SymbolTable();
        file.setSymbolTable(this.currentSymbolTable);
    }

    private void visitDeclaration(Declaration declaration) {
        Symbol symbol = this.currentSymbolTable.addSymbol(declaration.declaratedName().value().toLowerCase(Locale.ROOT));
        symbol.addUsage(declaration, Usage.Kind.ASSIGNMENT);
    }

    void visitAccessUsage(HasIdentifier tree) {
        if (tree.symbol() != null) {
            return;
        }
        Expression identifier = tree.identifier();
        if (identifier instanceof Identifier) {
            Identifier identifierTree = (Identifier)identifier;
            this.addAccessUsageIfSymbolExists(tree, identifierTree.value());
        } else {
            this.currentSymbolTable.foundUnresolvableSymbolAccess(tree);
        }
    }

    private void addAccessUsageIfSymbolExists(ArmTree tree, String symbolName) {
        Symbol symbol = this.currentSymbolTable.getSymbol(symbolName.toLowerCase(Locale.ROOT));
        if (symbol != null) {
            symbol.addUsage(tree, Usage.Kind.ACCESS);
        }
    }

    private void visitIdentifierJson(IdentifierImpl identifier) {
        String variableName = ArmSymbolVisitor.containsMentionOfVariable(identifier.value());
        if (variableName != null) {
            this.addAccessUsageIfSymbolExists(identifier, variableName);
        }
    }

    @CheckForNull
    private static String containsMentionOfVariable(String value) {
        Matcher matcher = ASSIGNED_IDENTITIES_PATTERN.matcher(value);
        if (matcher.find()) {
            return matcher.group("variableName");
        }
        return null;
    }
}

