/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.visitors;

import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.FunctionCall;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.OutputDeclaration;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.bicep.AmbientTypeReference;
import org.sonar.iac.arm.tree.api.bicep.Declaration;
import org.sonar.iac.arm.tree.api.bicep.Decorator;
import org.sonar.iac.arm.tree.api.bicep.ForExpression;
import org.sonar.iac.arm.tree.api.bicep.ForVariableBlock;
import org.sonar.iac.arm.tree.api.bicep.HasKeyword;
import org.sonar.iac.arm.tree.api.bicep.HasToken;
import org.sonar.iac.arm.tree.api.bicep.InterpolatedString;
import org.sonar.iac.arm.tree.api.bicep.MultilineString;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.api.bicep.variable.LocalVariable;
import org.sonar.iac.arm.tree.impl.json.FileImpl;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.yaml.visitors.YamlHighlightingVisitor;

public class ArmHighlightingVisitor
extends YamlHighlightingVisitor {
    @Override
    protected void languageSpecificHighlighting() {
        this.register(ForVariableBlock.class, (ctx, tree) -> this.highlight(tree.itemIdentifier(), TypeOfText.ANNOTATION));
        this.register(LocalVariable.class, (ctx, tree) -> this.highlight(tree.identifier(), TypeOfText.ANNOTATION));
        this.register(Property.class, (ctx, tree) -> this.highlight(tree.key(), TypeOfText.ANNOTATION));
        this.register(HasToken.class, (ctx, tree) -> this.highlight(tree.token(), TypeOfText.CONSTANT));
        this.register(HasKeyword.class, (ctx, tree) -> this.highlight(tree.keyword(), TypeOfText.KEYWORD));
        this.register(OutputDeclaration.class, (ctx, tree) -> this.highlight(tree.type(), TypeOfText.KEYWORD));
        this.register(Decorator.class, (ctx, tree) -> {
            Expression expression = tree.expression();
            if (expression instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)expression;
                this.highlight(functionCall.name(), TypeOfText.KEYWORD);
            }
        });
        this.register(ForExpression.class, (ctx, tree) -> {
            this.highlight(tree.forKeyword(), TypeOfText.KEYWORD);
            this.highlight(tree.inKeyword(), TypeOfText.KEYWORD);
        });
        this.register(Declaration.class, (ctx, tree) -> this.highlight(tree.declaratedName(), TypeOfText.KEYWORD_LIGHT));
        this.register(ResourceDeclaration.class, (ctx, tree) -> {
            SyntaxToken existing;
            Identifier identifier = tree.symbolicName();
            if (identifier != null) {
                this.highlight(identifier, TypeOfText.KEYWORD_LIGHT);
            }
            if ((existing = tree.existing()) != null) {
                this.highlight(existing, TypeOfText.KEYWORD);
            }
        });
        this.registerTree(AmbientTypeReference.class, TypeOfText.KEYWORD);
        this.registerTree(InterpolatedString.class, TypeOfText.STRING);
        this.registerTree(MultilineString.class, TypeOfText.STRING);
    }

    private <T extends ArmTree> void registerTree(Class<T> cls, TypeOfText type) {
        this.register(cls, (ctx, tree) -> {
            if (ArmTreeUtils.getRootNode(tree) instanceof FileImpl) {
                return;
            }
            this.highlight((HasTextRange)tree, type);
        });
    }
}

