/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.json;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.symbols.SymbolTable;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.Statement;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.yaml.tree.MappingTree;

public class FileImpl
extends AbstractArmTreeImpl
implements File {
    @Nullable
    private final StringLiteral targetScope;
    private final List<Statement> statements;
    private final MappingTree document;
    private SymbolTable symbolTable;

    public FileImpl(@Nullable StringLiteral targetScope, List<Statement> statements, MappingTree document) {
        this.targetScope = targetScope;
        this.statements = statements;
        this.document = document;
    }

    @Override
    public List<Tree> children() {
        return new ArrayList<Tree>(this.statements);
    }

    @Override
    public File.Scope targetScope() {
        String scopeSuffix;
        if (this.targetScope == null) {
            return File.Scope.NOT_SET;
        }
        String scopeAsString = this.targetScope.value();
        return switch (scopeSuffix = scopeAsString.substring(scopeAsString.lastIndexOf(47))) {
            case "/managementGroupDeploymentTemplate.json#" -> File.Scope.MANAGEMENT_GROUP;
            case "/deploymentTemplate.json#" -> File.Scope.RESOURCE_GROUP;
            case "/subscriptionDeploymentTemplate.json#" -> File.Scope.SUBSCRIPTION;
            case "/tenantDeploymentTemplate.json#" -> File.Scope.TENANT;
            default -> File.Scope.UNKNOWN;
        };
    }

    @Override
    @CheckForNull
    public StringLiteral targetScopeLiteral() {
        return this.targetScope;
    }

    @Override
    public List<Statement> statements() {
        return this.statements;
    }

    public MappingTree document() {
        return this.document;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.FILE;
    }

    @Override
    @Nullable
    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        if (this.symbolTable != null) {
            throw new IllegalArgumentException("A symbolTable is already set");
        }
        this.symbolTable = symbolTable;
    }
}

