/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.api;

import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.HasResources;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.Statement;
import org.sonar.iac.arm.tree.api.bicep.ObjectProperty;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.checks.TextUtils;

public interface ResourceDeclaration
extends Statement,
HasProperties,
ObjectProperty,
HasResources {
    @CheckForNull
    public Expression name();

    @CheckForNull
    public Identifier symbolicName();

    @CheckForNull
    public Expression version();

    public TextTree type();

    public List<Property> properties();

    @CheckForNull
    public SyntaxToken existing();

    public List<Property> resourceProperties();

    default public Optional<Property> getResourceProperty(String key) {
        return this.resourceProperties().stream().filter(p -> TextUtils.isValue(p.key(), key).isTrue()).findFirst();
    }
}

