/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser.bicep;

import com.sonar.sslr.api.typed.Input;
import org.sonar.iac.arm.parser.BicepParser;
import org.sonar.iac.arm.parser.bicep.BicepLexicalGrammar;
import org.sonar.iac.arm.parser.bicep.BicepNodeBuilder;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.sslr.grammar.GrammarRuleKey;

public final class ArmTemplateExpressionParser
extends BicepParser {
    private final ArmTemplateExpressionNodeBuilder nodeBuilder;

    private ArmTemplateExpressionParser(ArmTemplateExpressionNodeBuilder nodeBuilder, GrammarRuleKey rootRule) {
        super(nodeBuilder, rootRule);
        this.nodeBuilder = nodeBuilder;
    }

    public static ArmTemplateExpressionParser create() {
        return new ArmTemplateExpressionParser(new ArmTemplateExpressionNodeBuilder(), (GrammarRuleKey)BicepLexicalGrammar.BINARY_EXPRESSION);
    }

    public ArmTree parse(ScalarTree scalar) {
        String expressionString = scalar.value().substring(1, scalar.value().length() - 1);
        TextRange scalarTextRange = scalar.metadata().textRange();
        TextRange expressionTextRange = TextRanges.range(scalarTextRange.start().line(), scalarTextRange.start().lineOffset() + 1, scalarTextRange.end().line(), scalarTextRange.end().lineOffset() - 1);
        this.nodeBuilder.setOriginalTextRange(expressionTextRange);
        return super.parse(expressionString);
    }

    private static class ArmTemplateExpressionNodeBuilder
    extends BicepNodeBuilder {
        private TextRange originalTextRange;

        private ArmTemplateExpressionNodeBuilder() {
        }

        @Override
        protected TextRange tokenRange(Input input, int startIndex, String value) {
            TextRange range = super.tokenRange(input, startIndex, value);
            int originalStartLine = this.originalTextRange.start().line();
            int startLineOffsetShift = 0;
            int endLineOffsetShift = 0;
            if (range.start().line() == 1) {
                int originalOffset = this.originalTextRange.start().lineOffset();
                startLineOffsetShift = originalOffset + 1;
                if (range.end().line() == 1) {
                    endLineOffsetShift = originalOffset;
                }
            }
            return TextRanges.range(range.start().line() + originalStartLine - 1, range.start().lineOffset() + startLineOffsetShift, range.end().line() + originalStartLine - 1, range.end().lineOffset() + endLineOffsetShift);
        }

        protected void setOriginalTextRange(TextRange originalTextRange) {
            this.originalTextRange = originalTextRange;
        }
    }
}

