/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.exceptions.ScannerException;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.iac.arm.parser.FileConverter;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.BasicTextPointer;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.YamlConverter;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.ScalarTreeImpl;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;

public class ArmJsonParser
implements TreeParser<Tree> {
    private final YamlParser yamlParser = new YamlParser(new ArmJsonConverter());
    @Nullable
    private InputFileContext inputFileContext;
    private String source;

    @Override
    public ArmTree parse(String source, @Nullable InputFileContext inputFileContext) {
        this.inputFileContext = inputFileContext;
        ArmTree file = this.convert(this.parseJson(source));
        ArmJsonParser.setParents(file);
        return file;
    }

    protected FileTree parseJson(String source) {
        this.source = source;
        InputFile inputFile = this.inputFileContext != null ? this.inputFileContext.inputFile : null;
        try {
            return (FileTree)this.yamlParser.parse(source, this.inputFileContext);
        }
        catch (ScannerException e) {
            TextPointer position = e.getContextMark().map(mark -> new BasicTextPointer(mark.getLine() + 1, mark.getColumn())).orElse(null);
            throw ParseException.createGeneralParseException("parse", inputFile, e, position);
        }
        catch (Exception e) {
            throw ParseException.createGeneralParseException("parse", inputFile, e, null);
        }
    }

    private ArmTree convert(FileTree fileTree) {
        FileConverter fileConverter = new FileConverter(this.inputFileContext);
        return fileConverter.convertFile(fileTree);
    }

    private static void setParents(ArmTree tree) {
        for (Tree children : tree.children()) {
            ArmTree child = (ArmTree)children;
            child.setParent(tree);
            ArmJsonParser.setParents(child);
        }
    }

    class ArmJsonConverter
    extends YamlConverter {
        ArmJsonConverter() {
        }

        @Override
        public YamlTree convertScalar(ScalarNode node) {
            YamlTreeMetadata metadata = YamlTreeMetadata.builder().fromNode(node).build();
            String value = node.getValue();
            if (ArmJsonConverter.isMultilineScalar(metadata)) {
                value = this.originalStringValue(metadata);
            }
            return new ScalarTreeImpl(value, ArmJsonConverter.scalarStyleConvert(node.getScalarStyle()), metadata);
        }

        private String originalStringValue(YamlTreeMetadata metadata) {
            return ArmJsonParser.this.source.substring(metadata.startPointer() + 1, metadata.endPointer() - 1);
        }

        private static boolean isMultilineScalar(YamlTreeMetadata metadata) {
            TextRange range = metadata.textRange();
            return range.start().line() != range.end().line();
        }
    }
}

