/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.utils;

import java.util.Collection;
import java.util.function.Predicate;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.BooleanLiteral;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.FunctionCall;
import org.sonar.iac.arm.tree.api.NumericLiteral;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.bicep.MemberExpression;
import org.sonar.iac.arm.tree.api.bicep.expression.UnaryExpression;
import org.sonar.iac.common.checks.TextUtils;

public final class CheckUtils {
    private CheckUtils() {
    }

    public static Predicate<Expression> isValue(Predicate<String> predicate) {
        return expr -> TextUtils.matchesValue(expr, predicate).isTrue();
    }

    public static Predicate<Expression> isEqual(String targetString) {
        return expr -> TextUtils.matchesValue(expr, targetString::equals).isTrue();
    }

    public static Predicate<Expression> isRegexMatch(String regex) {
        return expr -> TextUtils.getValue(expr).filter(str -> str.matches(regex)).isPresent();
    }

    public static Predicate<Expression> contains(String targetString) {
        return expr -> TextUtils.matchesValue(expr, str -> str.contains(targetString)).isTrue();
    }

    public static Predicate<Expression> containsRecursively(String targetString) {
        return expr -> CheckUtils.containsRecursively(expr, targetString);
    }

    private static boolean containsRecursively(ArmTree tree, String targetString) {
        return TextUtils.matchesValue(tree, str -> str.contains(targetString)).isTrue() || tree.children().stream().anyMatch(child -> CheckUtils.containsRecursively((ArmTree)child, targetString));
    }

    public static Predicate<Expression> isTrue() {
        return expr -> expr.is(ArmTree.Kind.BOOLEAN_LITERAL) && ((BooleanLiteral)expr).value();
    }

    public static Predicate<Expression> isFalse() {
        return expr -> expr.is(ArmTree.Kind.BOOLEAN_LITERAL) && !((BooleanLiteral)expr).value();
    }

    public static Predicate<Expression> isNull() {
        return expr -> expr.is(ArmTree.Kind.NULL_LITERAL);
    }

    public static Predicate<Expression> isBlankString() {
        return expr -> TextUtils.matchesValue(ArmTreeUtils.retrieveIdentifierOrExpression(expr), String::isBlank).isTrue();
    }

    public static Predicate<Expression> isArrayWithValues() {
        return expr -> expr.is(ArmTree.Kind.ARRAY_EXPRESSION) && !((ArrayExpression)expr).elements().isEmpty();
    }

    public static Predicate<Expression> isEmptyArray() {
        return expr -> expr.is(ArmTree.Kind.ARRAY_EXPRESSION) && ((ArrayExpression)expr).elements().isEmpty();
    }

    public static Predicate<Expression> isEmptyObject() {
        return expr -> expr.is(ArmTree.Kind.OBJECT_EXPRESSION) && ((ObjectExpression)expr).properties().isEmpty();
    }

    public static Predicate<Expression> isFunctionCall(String functionName) {
        return expr -> expr.is(ArmTree.Kind.FUNCTION_CALL) && ((FunctionCall)expr).name().value().equals(functionName);
    }

    public static Predicate<Expression> isFunctionCallWithPropertyAccess(String functionName, String propertyName) {
        return expr -> {
            if (expr instanceof MemberExpression) {
                MemberExpression memberExpression = (MemberExpression)expr;
                return memberExpression.separatingToken().value().equals(".") && CheckUtils.isFunctionCall(functionName).test(memberExpression.memberAccess()) && TextUtils.isValue(memberExpression.expression(), propertyName).isTrue();
            }
            return false;
        };
    }

    public static Predicate<Expression> inCollection(Collection<String> collection) {
        return expr -> TextUtils.matchesValue(expr, collection::contains).isTrue();
    }

    public static Double asNumericValueOrNull(ArmTree expr) {
        UnaryExpression unaryExpression;
        if (expr.is(ArmTree.Kind.NUMERIC_LITERAL)) {
            return ((NumericLiteral)expr).asDouble();
        }
        if (expr.is(ArmTree.Kind.UNARY_EXPRESSION) && (unaryExpression = (UnaryExpression)expr).expression().is(ArmTree.Kind.NUMERIC_LITERAL)) {
            double factor = unaryExpression.operator().value().equals("-") ? -1.0 : 1.0;
            return ((NumericLiteral)unaryExpression.expression()).asDouble() * factor;
        }
        return null;
    }
}

