/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.elementsorder;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sonar.iac.arm.tree.impl.json.FileImpl;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.TupleTree;

public class TopLevelPropertiesOrderJson
implements IacCheck {
    private static final String MESSAGE = "Reorder the elements to match the recommended order.";
    private static final Map<String, Integer> TOP_LEVEL_JSON_ELEMENTS = Map.of("$schema", 0, "contentversion", 1, "metadata", 2, "apiprofile", 3, "parameters", 4, "functions", 5, "variables", 6, "resources", 7, "outputs", 8);

    @Override
    public void initialize(InitContext init) {
        init.register(FileImpl.class, TopLevelPropertiesOrderJson::checkTopLevelJson);
    }

    private static void checkTopLevelJson(CheckContext checkContext, FileImpl file) {
        MappingTree document = file.document();
        List<ScalarTree> elements = document.elements().stream().map(TupleTree::key).filter(ScalarTree.class::isInstance).map(ScalarTree.class::cast).filter(tree -> TOP_LEVEL_JSON_ELEMENTS.containsKey(tree.value().toLowerCase(Locale.ROOT))).toList();
        int prevIndex = 0;
        for (ScalarTree element : elements) {
            Integer index = TOP_LEVEL_JSON_ELEMENTS.get(element.value().toLowerCase(Locale.ROOT));
            if (index < prevIndex) {
                checkContext.reportIssue(element, MESSAGE);
                break;
            }
            prevIndex = index;
        }
    }
}

