/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks.elementsorder;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.impl.json.ResourceDeclarationImpl;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

public class ElementsOrderResourceCheckJson
implements IacCheck {
    private static final String MESSAGE = "Reorder the elements to match the recommended order.";
    private static final Map<String, Integer> ELEMENTS_ORDER = new HashMap<String, Integer>();
    private static final int DEFAULT_ORDER_FOR_UNKNOWN_PROPERTY = 20;

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclarationImpl.class, ElementsOrderResourceCheckJson::checkResource);
    }

    private static void checkResource(CheckContext checkContext, ResourceDeclarationImpl resourceDeclaration) {
        int prevIndex = 0;
        for (Property property : resourceDeclaration.resourceProperties()) {
            Integer index = ELEMENTS_ORDER.getOrDefault(property.key().value().toLowerCase(Locale.ROOT), 20);
            if (index < prevIndex) {
                checkContext.reportIssue(property.key(), MESSAGE);
                break;
            }
            prevIndex = index;
        }
    }

    static {
        ELEMENTS_ORDER.put("comments", 0);
        ELEMENTS_ORDER.put("condition", 1);
        ELEMENTS_ORDER.put("scope", 2);
        ELEMENTS_ORDER.put("type", 3);
        ELEMENTS_ORDER.put("apiversion", 4);
        ELEMENTS_ORDER.put("name", 5);
        ELEMENTS_ORDER.put("location", 6);
        ELEMENTS_ORDER.put("zones", 7);
        ELEMENTS_ORDER.put("sku", 8);
        ELEMENTS_ORDER.put("kind", 9);
        ELEMENTS_ORDER.put("scale", 10);
        ELEMENTS_ORDER.put("plan", 11);
        ELEMENTS_ORDER.put("identity", 12);
        ELEMENTS_ORDER.put("copy", 13);
        ELEMENTS_ORDER.put("dependson", 14);
        ELEMENTS_ORDER.put("tags", 15);
        ELEMENTS_ORDER.put("properties", 100);
    }
}

