/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.check.Rule;
import org.sonar.iac.arm.checks.AbstractUnusedSymbolCheck;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.common.api.checks.CheckContext;

@Rule(key="S6955")
public class UnusedParametersCheck
extends AbstractUnusedSymbolCheck {
    @Override
    void checkSymbols(CheckContext checkContext, File file) {
        StringLiteral literal;
        Expression expression = file.targetScopeLiteral();
        if (expression instanceof StringLiteral && (literal = (StringLiteral)expression).value().endsWith("deploymentParameters.json#")) {
            return;
        }
        super.checkSymbols(checkContext, file);
    }

    @Override
    ArmTree.Kind declarationKind() {
        return ArmTree.Kind.PARAMETER_DECLARATION;
    }

    @Override
    String typeOfSymbol() {
        return "parameter";
    }
}

