/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.check.Rule;
import org.sonar.iac.arm.checkdsl.ContextualProperty;
import org.sonar.iac.arm.checkdsl.ContextualResource;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.common.api.checks.SecondaryLocation;

@Rule(key="S6383")
public class RoleBasedAccessControlCheck
extends AbstractArmResourceCheck {
    private static final String MESSAGE_MISSING_PARAMETER = "Omitting '%s' disables role-based access control for this resource. Make sure it is safe here.";
    private static final String MESSAGE_DISABLED_PARAMETER = "Make sure that disabling role-based access control is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.ContainerService/managedClusters", RoleBasedAccessControlCheck::checkAzureKubernetesService);
        this.register("Microsoft.KeyVault/vaults", RoleBasedAccessControlCheck::checkKeyVault);
    }

    private static void checkAzureKubernetesService(ContextualResource resource) {
        resource.object("aadProfile").property("enableAzureRBAC").reportIf(CheckUtils.isFalse(), MESSAGE_DISABLED_PARAMETER, new SecondaryLocation[0]);
        resource.property("enableRBAC").reportIf(CheckUtils.isFalse(), MESSAGE_DISABLED_PARAMETER, new SecondaryLocation[0]);
    }

    private static void checkKeyVault(ContextualResource resource) {
        ((ContextualProperty)resource.property("enableRbacAuthorization").reportIfAbsent(MESSAGE_MISSING_PARAMETER, new SecondaryLocation[0])).reportIf(CheckUtils.isFalse(), MESSAGE_DISABLED_PARAMETER, new SecondaryLocation[0]);
    }
}

