/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checks.utils.CheckUtils;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.FunctionCall;
import org.sonar.iac.arm.tree.api.HasIdentifier;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.MemberExpression;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6952")
public class RedundantResourceDependenciesCheck
implements IacCheck {
    private static final String MESSAGE = "Remove this explicit dependency as it is already defined implicitly.";
    private static final String SECONDARY_MESSAGE_REFERENCE = "Implicit dependency is created via the \"reference\" function.";
    private static final String SECONDARY_MESSAGE_SYMBOLIC = "Implicit dependency is created via a symbolic name.";
    private static final int NUM_ARGUMENTS_IN_BASIC_RESOURCE_ID = 2;
    private static final Predicate<Expression> IS_REFERENCE_FUNCTION = CheckUtils.isFunctionCall("reference").or(CheckUtils.isFunctionCall("references"));

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclaration.class, RedundantResourceDependenciesCheck::collectExplicitDependencies);
    }

    private static void collectExplicitDependencies(CheckContext checkContext, ResourceDeclaration resourceDeclaration) {
        Optional<ArrayExpression> resourceExplicitDependencies = resourceDeclaration.getResourceProperty("dependsOn").map(Property::value).filter(ArrayExpression.class::isInstance).map(ArrayExpression.class::cast);
        if (resourceExplicitDependencies.isEmpty()) {
            return;
        }
        List<TextTree> explicitDependencies = RedundantResourceDependenciesCheck.collectDependencies(resourceExplicitDependencies.get());
        List<StringLiteral> referencedResources = RedundantResourceDependenciesCheck.collectReferences(resourceDeclaration);
        List<TextTree> referencedResourcesSymbolic = RedundantResourceDependenciesCheck.collectSymbolicReferences(resourceDeclaration);
        for (TextTree dependency : explicitDependencies) {
            String dependencyName = dependency.value();
            Stream<StringLiteral> references = referencedResources.stream().filter(referencedResource -> dependencyName.equals(referencedResource.value()));
            Stream<TextTree> symbolicReferences = referencedResourcesSymbolic.stream().filter(symbolicResource -> dependencyName.equals(symbolicResource.value()));
            List<SecondaryLocation> secondaryLocations = Stream.concat(references.map(textTree -> new SecondaryLocation((HasTextRange)textTree, SECONDARY_MESSAGE_REFERENCE)), symbolicReferences.map(textTree -> new SecondaryLocation((HasTextRange)textTree, SECONDARY_MESSAGE_SYMBOLIC))).toList();
            if (secondaryLocations.isEmpty()) continue;
            checkContext.reportIssue((HasTextRange)dependency, MESSAGE, secondaryLocations);
        }
    }

    private static List<TextTree> collectDependencies(ArrayExpression dependsOn) {
        return dependsOn.elements().stream().map(RedundantResourceDependenciesCheck::extractDependencyTextTree).filter(Objects::nonNull).toList();
    }

    @CheckForNull
    private static TextTree extractDependencyTextTree(Expression expression) {
        FunctionCall functionCall;
        if (expression instanceof FunctionCall && TextUtils.matchesValue((functionCall = (FunctionCall)expression).name(), name -> "resourceId".equals(name) || name.endsWith("ResourceId")).isTrue()) {
            Expression expression2;
            if (functionCall.argumentList().elements().size() == 2 && (expression2 = functionCall.argumentList().elements().get(1)) instanceof TextTree) {
                TextTree textTree = (TextTree)((Object)expression2);
                return textTree;
            }
        } else {
            HasIdentifier hasIdentifier;
            Expression expression3;
            if (expression instanceof MemberExpression) {
                MemberExpression memberExpression = (MemberExpression)expression;
                return RedundantResourceDependenciesCheck.extractDependencyTextTree(memberExpression.memberAccess());
            }
            if (expression instanceof HasIdentifier && (expression3 = (hasIdentifier = (HasIdentifier)expression).identifier()) instanceof TextTree) {
                TextTree textTree = (TextTree)((Object)expression3);
                return textTree;
            }
            if (expression instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)expression;
                return stringLiteral;
            }
        }
        return null;
    }

    private static List<StringLiteral> collectReferences(ResourceDeclaration resourceDeclaration) {
        return resourceDeclaration.properties().stream().flatMap(property -> RedundantResourceDependenciesCheck.getAllPropertyValues(property.value())).flatMap(expression -> ArmTreeUtils.findAllNodes(expression, FunctionCall.class)).filter(IS_REFERENCE_FUNCTION).map(functionCall -> functionCall.argumentList().elements().get(0)).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).toList();
    }

    private static List<TextTree> collectSymbolicReferences(ResourceDeclaration resourceDeclaration) {
        return resourceDeclaration.properties().stream().flatMap(property -> RedundantResourceDependenciesCheck.getAllPropertyValues(property.value())).flatMap(expression -> ArmTreeUtils.findAllNodes(expression, HasIdentifier.class)).map(HasIdentifier::identifier).filter(TextTree.class::isInstance).map(TextTree.class::cast).toList();
    }

    private static Stream<Expression> getAllPropertyValues(Expression expression) {
        if (expression instanceof ObjectExpression) {
            ObjectExpression objectExpression = (ObjectExpression)expression;
            return objectExpression.allPropertiesFlattened().flatMap(prop -> RedundantResourceDependenciesCheck.getAllPropertyValues(prop.value()));
        }
        if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            return arrayExpression.elements().stream().flatMap(RedundantResourceDependenciesCheck::getAllPropertyValues);
        }
        return Stream.of(expression);
    }
}

