/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.arm.checks.AbstractArmResourceCheck;
import org.sonar.iac.arm.tree.ArmTreeUtils;
import org.sonar.iac.arm.tree.api.ArrayExpression;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.IpRestrictedAdminAccessCheckUtils;

@Rule(key="S6321")
public class IpRestrictedAdminAccessCheck
extends AbstractArmResourceCheck {
    private static final Set<String> SOURCE_ADDRESS_PREFIX_SENSITIVE = Set.of("*", "0.0.0.0/0", "::/0", "Internet");
    private static final Set<String> SENSITIVE_PROTOCOL = Set.of("*", "TCP");

    @Override
    protected void registerResourceConsumer() {
        this.register("Microsoft.Network/networkSecurityGroups/securityRules", (CheckContext ctx, ResourceDeclaration resource) -> IpRestrictedAdminAccessCheck.checkResourcePath(ctx, resource, Collections.emptyList()));
        this.register("Microsoft.Network/networkSecurityGroup", IpRestrictedAdminAccessCheck.checkResourcePath("securityRules/*/properties"));
        this.register("Microsoft.Network/virtualNetworks/subnets", IpRestrictedAdminAccessCheck.checkResourcePath("networkSecurityGroup/properties/securityRules/*/properties"));
        this.register("Microsoft.Network/virtualNetworks", IpRestrictedAdminAccessCheck.checkResourcePath("subnets/*/properties/networkSecurityGroup/properties/securityRules/*/properties"));
        this.register("Microsoft.Network/networkInterfaces", IpRestrictedAdminAccessCheck.checkResourcePath("ipConfigurations/*/properties/subnet/properties/networkSecurityGroup/properties/securityRules/*/properties"));
    }

    private static BiConsumer<CheckContext, ResourceDeclaration> checkResourcePath(String path) {
        return (ctx, resource) -> IpRestrictedAdminAccessCheck.checkResourcePath(ctx, resource, ArmTreeUtils.computePath(path));
    }

    private static void checkResourcePath(CheckContext ctx, ResourceDeclaration resource, List<String> path) {
        List<Tree> listProperties = ArmTreeUtils.resolveProperties(new LinkedList<String>(path), (Tree)resource);
        for (Tree properties : listProperties) {
            ResourceWithIpRestrictedAdminAccessChecker checker = new ResourceWithIpRestrictedAdminAccessChecker(resource, properties);
            if (!checker.isSensitive()) continue;
            checker.reportIssue(ctx);
        }
    }

    static class ResourceWithIpRestrictedAdminAccessChecker {
        Tree primaryLocation;
        @Nullable
        Tree direction;
        @Nullable
        Tree access;
        @Nullable
        Tree protocol;
        @Nullable
        Tree destinationPortRange;
        @Nullable
        Tree destinationPortRanges;
        @Nullable
        Tree sourceAddressPrefix;
        @Nullable
        Tree sourceAddressPrefixes;

        ResourceWithIpRestrictedAdminAccessChecker(ResourceDeclaration resource, Tree properties) {
            this.primaryLocation = resource.type();
            this.direction = PropertyUtils.value(properties, "direction").orElse(null);
            this.access = PropertyUtils.value(properties, "access").orElse(null);
            this.protocol = PropertyUtils.value(properties, "protocol").orElse(null);
            this.destinationPortRange = PropertyUtils.value(properties, "destinationPortRange").orElse(null);
            this.destinationPortRanges = PropertyUtils.value(properties, "destinationPortRanges").orElse(null);
            this.sourceAddressPrefix = PropertyUtils.value(properties, "sourceAddressPrefix").orElse(null);
            this.sourceAddressPrefixes = PropertyUtils.value(properties, "sourceAddressPrefixes").orElse(null);
        }

        boolean isSensitive() {
            return !(!TextUtils.isValue(this.direction, "Inbound").isTrue() || !TextUtils.isValue(this.access, "Allow").isTrue() || !TextUtils.matchesValue(this.protocol, str -> SENSITIVE_PROTOCOL.contains(str.toUpperCase(Locale.ROOT))).isTrue() || !this.isSensitivePort(this.destinationPortRange) && !ResourceWithIpRestrictedAdminAccessChecker.isArrayWith(this.destinationPortRanges, this::isSensitivePort) || !this.isSensitiveSourceAddressString(this.sourceAddressPrefix) && !ResourceWithIpRestrictedAdminAccessChecker.isArrayWith(this.sourceAddressPrefixes, this::isSensitiveSourceAddressString));
        }

        void reportIssue(CheckContext ctx) {
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            if (this.sourceAddressPrefix != null) {
                secondaryLocations.add(new SecondaryLocation(this.sourceAddressPrefix, "Sensitive source address prefix"));
            } else {
                secondaryLocations.add(new SecondaryLocation(this.sourceAddressPrefixes, "Sensitive source(s) address prefix(es)"));
            }
            secondaryLocations.add(new SecondaryLocation(this.direction, "Sensitive direction"));
            secondaryLocations.add(new SecondaryLocation(this.access, "Sensitive access"));
            secondaryLocations.add(new SecondaryLocation(this.protocol, "Sensitive protocol"));
            if (this.destinationPortRange != null) {
                secondaryLocations.add(new SecondaryLocation(this.destinationPortRange, "Sensitive destination port range"));
            } else {
                secondaryLocations.add(new SecondaryLocation(this.destinationPortRanges, "Sensitive destination(s) port range(s)"));
            }
            ctx.reportIssue((HasTextRange)this.primaryLocation, "Restrict IP addresses authorized to access administration services.", secondaryLocations);
        }

        private static boolean isArrayWith(@Nullable Tree tree, Predicate<Tree> predicate) {
            if (tree instanceof ArrayExpression) {
                ArrayExpression arrayExpression = (ArrayExpression)tree;
                return arrayExpression.elements().stream().anyMatch(predicate);
            }
            return false;
        }

        private boolean isSensitiveSourceAddressString(Tree value) {
            return TextUtils.matchesValue(value, SOURCE_ADDRESS_PREFIX_SENSITIVE::contains).isTrue();
        }

        private boolean isSensitivePort(Tree tree) {
            return TextUtils.getValue(tree).filter(IpRestrictedAdminAccessCheckUtils::rangeContainsSshOrRdpPort).isPresent();
        }
    }
}

