/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.check.Rule;
import org.sonar.iac.arm.tree.api.HasIdentifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

@Rule(key="S6949")
public class HardcodedResourceLocationCheck
implements IacCheck {
    private static final String MESSAGE = "Replace this hardcoded location with a parameter.";

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclaration.class, HardcodedResourceLocationCheck::checkResourceLocation);
    }

    private static void checkResourceLocation(CheckContext ctx, ResourceDeclaration resource) {
        resource.getResourceProperty("location").map(Property::value).filter(tree -> !(tree instanceof HasIdentifier)).ifPresent(tree -> ctx.reportIssue(tree.textRange(), MESSAGE));
    }
}

