/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.checks;

import org.sonar.check.Rule;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;

@Rule(key="S6874")
public class HardcodeApiVersionCheck
implements IacCheck {
    private static final String MESSAGE = "Use a hard-coded value for the apiVersion of this resource.";

    @Override
    public void initialize(InitContext init) {
        init.register(ResourceDeclaration.class, HardcodeApiVersionCheck::checkApiVersionIsHardcoded);
    }

    private static void checkApiVersionIsHardcoded(CheckContext checkContext, ResourceDeclaration resourceDeclaration) {
        Expression apiVersion = resourceDeclaration.version();
        if (apiVersion == null || apiVersion instanceof StringLiteral) {
            return;
        }
        checkContext.reportIssue(apiVersion.textRange(), MESSAGE);
    }
}

