/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LengthPrefixSerializer {
    private LengthPrefixSerializer() {
    }

    public static byte[] serializeList(List<byte[]> toSerializeList) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(byteArrayOutputStream);){
                for (byte[] toSerializeElement : toSerializeList) {
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement);
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    public static List<byte[]> unserializeList(byte[] data) throws IOException {
        return LengthPrefixSerializer.unserializeList(new ByteArrayInputStream(data));
    }

    public static List<byte[]> unserializeList(InputStream data) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (DataInputStream dis = new DataInputStream(data);){
            while (dis.available() > 0) {
                result.add(LengthPrefixSerializer.readBytes(dis));
            }
        }
        return result;
    }

    public static byte[] serializeMap(Map<String, byte[]> toSerializeMap) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(byteArrayOutputStream);){
                for (Map.Entry<String, byte[]> toSerializeElement : toSerializeMap.entrySet()) {
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement.getKey().getBytes(StandardCharsets.UTF_8));
                    LengthPrefixSerializer.writeLengthAndBytes(dos, toSerializeElement.getValue());
                }
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    public static Map<String, byte[]> unserializeMap(byte[] data) throws IOException {
        return LengthPrefixSerializer.unserializeMap(new ByteArrayInputStream(data));
    }

    public static Map<String, byte[]> unserializeMap(InputStream data) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try (DataInputStream dis = new DataInputStream(data);){
            while (dis.available() > 0) {
                String key = new String(LengthPrefixSerializer.readBytes(dis), StandardCharsets.UTF_8);
                byte[] value = LengthPrefixSerializer.readBytes(dis);
                result.put(key, value);
            }
        }
        return result;
    }

    private static byte[] readBytes(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        LengthPrefixSerializer.validateLength(length);
        byte[] bytes = new byte[length];
        dis.readFully(bytes);
        return bytes;
    }

    private static void writeLengthAndBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        dos.writeInt(bytes.length);
        dos.write(bytes);
    }

    private static void validateLength(int length) throws IOException {
        if (length < 0) {
            throw new IOException("Invalid length while unserializing: " + length);
        }
    }
}

