/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.YamlFileUtils;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.helm.ShiftedMarkedYamlEngineException;
import org.sonar.iac.kubernetes.plugin.HelmProcessor;
import org.sonar.iac.kubernetes.plugin.KubernetesParserStatistics;
import org.sonar.iac.kubernetes.tree.impl.KubernetesFileTreeImpl;
import org.sonar.iac.kubernetes.visitors.HelmInputFileContext;
import org.sonar.iac.kubernetes.visitors.LocationShifter;

public class KubernetesParser
extends YamlParser {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesParser.class);
    private static final String DIRECTIVE_IN_COMMENT = "#.*\\{\\{";
    private static final String DIRECTIVE_IN_SINGLE_QUOTE = "'[^']*\\{\\{[^']*'";
    private static final String DIRECTIVE_IN_DOUBLE_QUOTE = "\"[^\"]*\\{\\{[^\"]*\"";
    private static final String CODEFRESH_VARIABLES = "\\$\\{\\{[\\w\\s]+}}";
    private static final Pattern HELM_DIRECTIVE_IN_COMMENT_OR_STRING = Pattern.compile("(" + String.join((CharSequence)"|", "#.*\\{\\{", "'[^']*\\{\\{[^']*'", "\"[^\"]*\\{\\{[^\"]*\"", "\\$\\{\\{[\\w\\s]+}}") + ")");
    private final HelmProcessor helmProcessor;
    private final KubernetesParserStatistics kubernetesParserStatistics;

    public KubernetesParser(HelmProcessor helmProcessor, KubernetesParserStatistics kubernetesParserStatistics) {
        this.helmProcessor = helmProcessor;
        this.kubernetesParserStatistics = kubernetesParserStatistics;
    }

    @Override
    public FileTree parse(String source, @Nullable InputFileContext inputFileContext) {
        if (!KubernetesParser.hasHelmContent(source)) {
            return this.kubernetesParserStatistics.recordPureKubernetesFile(() -> super.parse(source, inputFileContext));
        }
        return this.kubernetesParserStatistics.recordHelmFile(() -> this.parseHelmFile(source, (HelmInputFileContext)inputFileContext));
    }

    private FileTree parseHelmFile(String source, @Nullable HelmInputFileContext inputFileContext) {
        FileTree result;
        if (inputFileContext == null) {
            LOG.debug("No InputFileContext provided, skipping processing of Helm file");
            return this.buildEmptyTree();
        }
        if (KubernetesParser.isInvalidHelmInputFile(inputFileContext)) {
            return this.buildEmptyTree();
        }
        LOG.debug("Helm content detected in file '{}'", (Object)inputFileContext.inputFile);
        if (!this.helmProcessor.isHelmEvaluatorInitialized()) {
            LOG.debug("Helm evaluator is not initialized, skipping processing of Helm file {}", (Object)inputFileContext.inputFile);
            return this.buildEmptyTree();
        }
        try {
            result = this.evaluateAndParseHelmFile(source, inputFileContext);
        }
        catch (ParseException pe) {
            String details = pe.getDetails();
            if (details != null && details.contains("\" associated with template \"aggregatingTemplate\"")) {
                LOG.debug("Helm file {} requires a named template that is missing; this feature is not yet supported, skipping processing of Helm file", (Object)inputFileContext.inputFile);
                result = this.buildEmptyTree();
            }
            throw pe;
        }
        catch (MarkedYamlEngineException e) {
            MarkedYamlEngineException exception = LocationShifter.shiftMarkedYamlException(inputFileContext, e);
            if (exception instanceof ShiftedMarkedYamlEngineException) {
                ShiftedMarkedYamlEngineException shiftedMarkedException = (ShiftedMarkedYamlEngineException)exception;
                LOG.debug("Shifting YAML exception {}", (Object)shiftedMarkedException.describeShifting());
            }
            throw exception;
        }
        return result;
    }

    static boolean isInvalidHelmInputFile(HelmInputFileContext helmFileCtx) {
        return KubernetesParser.isValuesFile(helmFileCtx) || KubernetesParser.isChartFile(helmFileCtx) || KubernetesParser.isTplFile(helmFileCtx);
    }

    private static boolean isValuesFile(HelmInputFileContext helmFileCtx) {
        boolean isValuesYaml;
        String filename = helmFileCtx.inputFile.filename();
        boolean bl = isValuesYaml = "values.yaml".equals(filename) || "values.yml".equals(filename);
        if (isValuesYaml && helmFileCtx.isInChartRootDirectory()) {
            LOG.debug("Helm values file detected, skipping parsing {}", (Object)helmFileCtx.inputFile);
            return true;
        }
        return false;
    }

    private static boolean isChartFile(HelmInputFileContext helmFileCtx) {
        boolean isChartYaml = "Chart.yaml".equals(helmFileCtx.inputFile.filename());
        if (isChartYaml && helmFileCtx.isInChartRootDirectory()) {
            LOG.debug("Helm Chart.yaml file detected, skipping parsing {}", (Object)helmFileCtx.inputFile);
            return true;
        }
        return false;
    }

    private static boolean isTplFile(HelmInputFileContext helmFileCtx) {
        if (helmFileCtx.inputFile.filename().endsWith(".tpl")) {
            LOG.debug("Helm tpl file detected, skipping parsing {}", (Object)helmFileCtx.inputFile);
            return true;
        }
        return false;
    }

    private FileTree buildEmptyTree() {
        return super.parse("{}", null, FileTree.Template.HELM);
    }

    private FileTree evaluateAndParseHelmFile(String source, HelmInputFileContext inputFileContext) {
        String evaluatedAndCleanedSource = this.helmProcessor.process(source, inputFileContext);
        if (evaluatedAndCleanedSource.isBlank()) {
            LOG.debug("Blank evaluated file, skipping processing of Helm file {}", (Object)inputFileContext.inputFile);
            return super.parse("{}", null, FileTree.Template.HELM);
        }
        return KubernetesFileTreeImpl.fromFileTree(super.parse(evaluatedAndCleanedSource, inputFileContext, FileTree.Template.HELM), inputFileContext.getGoTemplateTree());
    }

    public static boolean hasHelmContent(String text) {
        String[] lines;
        for (String line : lines = YamlFileUtils.splitLines(text)) {
            if (!KubernetesParser.hasHelmContentInLine(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHelmContentInLine(String line) {
        return line.contains("{{") && !HELM_DIRECTIVE_IN_COMMENT_OR_STRING.matcher(line).find();
    }
}

