/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.checks;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.yaml.TreePredicates;
import org.sonar.iac.common.yaml.object.BlockObject;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.kubernetes.checks.AbstractKubernetesObjectCheck;
import org.sonar.iac.kubernetes.visitors.KubernetesCheckContext;

@Rule(key="S6867")
public class RBACWildcardCheck
extends AbstractKubernetesObjectCheck {
    private static final String MESSAGE = "Do not use wildcards when defining RBAC permissions.";
    private static final List<String> SENSITIVE_KINDS = List.of("Role", "ClusterRole");
    private static final List<String> SENSITIVE_RULE_ATTRIBUTES = List.of("resources", "verbs");

    @Override
    boolean shouldVisitWholeDocument() {
        return true;
    }

    @Override
    void registerObjectCheck() {
        this.register(SENSITIVE_KINDS, (BlockObject document) -> document.blocks("rules").forEach(rule -> SENSITIVE_RULE_ATTRIBUTES.forEach(attributeKey -> {
            if (RBACWildcardCheck.containsWildCardItem(rule, attributeKey)) {
                rule.attribute((String)attributeKey).reportOnValue(MESSAGE);
            }
        })));
    }

    @Override
    void initializeCheck(CheckContext ctx) {
        if (ctx instanceof KubernetesCheckContext) {
            KubernetesCheckContext kubernetesCtx = (KubernetesCheckContext)ctx;
            kubernetesCtx.setShouldReportSecondaryInValues(true);
        }
    }

    private static boolean containsWildCardItem(BlockObject rule, String listKey) {
        Predicate<YamlTree> wildcardPredicate = TreePredicates.isEqualTo("*");
        return rule.list(listKey).getItemIf(wildcardPredicate).findAny().isPresent();
    }
}

