/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.helm.tree.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.helm.tree.api.CommandNode;
import org.sonar.iac.helm.tree.api.FieldNode;
import org.sonar.iac.helm.tree.api.GoTemplateTree;
import org.sonar.iac.helm.tree.api.IdentifierNode;
import org.sonar.iac.helm.tree.api.Location;
import org.sonar.iac.helm.tree.api.Node;
import org.sonar.iac.helm.tree.api.NodeType;
import org.sonar.iac.helm.tree.impl.LocationImpl;
import org.sonar.iac.helm.tree.utils.ValuePath;

public final class GoTemplateAstHelper {
    private GoTemplateAstHelper() {
    }

    public static Stream<Node> findNodesToHighlight(GoTemplateTree tree, TextRange range, String sourceText) {
        Location location = LocationImpl.fromTextRange(range, sourceText);
        return Stream.concat(Stream.concat(GoTemplateAstHelper.findValuePathNodes(tree, location), GoTemplateAstHelper.findIncludeFunctionsFirstArg(tree, location)), GoTemplateAstHelper.findToYamlNodes(tree, location));
    }

    static Stream<FieldNode> findValuePathNodes(GoTemplateTree tree, Location location) {
        List<Node> nodes = tree.root().children().stream().filter(GoTemplateAstHelper.hasOverlayingLocation(location)).toList();
        return GoTemplateAstHelper.nodesWithImmediateChildren(nodes).stream().filter(FieldNode.class::isInstance).filter(GoTemplateAstHelper.hasOverlayingLocation(location)).map(FieldNode.class::cast);
    }

    public static List<ValuePath> findValuePaths(GoTemplateTree tree, TextRange range, String sourceText) {
        Location location = LocationImpl.fromTextRange(range, sourceText);
        return GoTemplateAstHelper.findValuePathNodes(tree, location).map(FieldNode::identifiers).map(ValuePath::new).toList();
    }

    private static Stream<Node> findIncludeFunctionsFirstArg(GoTemplateTree tree, Location location) {
        return GoTemplateAstHelper.collectNodesByType(tree.root(), NodeType.NODE_COMMAND, CommandNode.class).filter(GoTemplateAstHelper.hasOverlayingLocation(location)).filter(node -> GoTemplateAstHelper.isFunction(node, "include")).map(cmd -> cmd.arguments().get(1));
    }

    private static Stream<? extends Node> findToYamlNodes(GoTemplateTree tree, Location location) {
        return GoTemplateAstHelper.collectNodesByType(tree.root(), NodeType.NODE_COMMAND, CommandNode.class).filter(GoTemplateAstHelper.hasOverlayingLocation(location)).filter(node -> GoTemplateAstHelper.isFunction(node, "toYaml"));
    }

    private static Predicate<Node> hasOverlayingLocation(Location location) {
        return node -> {
            int position = location.position();
            int length = location.length();
            int nodePosition = node.location().position();
            int nodeLength = node.location().length();
            return nodePosition <= position + length && nodePosition + nodeLength >= position;
        };
    }

    private static List<Node> nodesWithImmediateChildren(List<Node> nodes) {
        ArrayList<Node> allNodes = new ArrayList<Node>(nodes);
        for (int i = 0; i < allNodes.size(); ++i) {
            allNodes.addAll(((Node)allNodes.get(i)).children());
        }
        return allNodes;
    }

    private static <T extends Node> Stream<T> collectNodesByType(Node node, NodeType type, Class<T> nodeClass) {
        return Stream.concat(Stream.of(node).filter(n -> type == n.type()), node.children().stream().flatMap(child -> GoTemplateAstHelper.collectNodesByType(child, type, nodeClass))).map(nodeClass::cast);
    }

    public static void addChildrenIfPresent(Collection<Node> children, @Nullable Node tree) {
        if (tree != null) {
            children.add(tree);
        }
    }

    private static boolean isFunction(CommandNode commandNode, String functionName) {
        IdentifierNode identifierNode;
        Node node;
        return commandNode.arguments().size() > 1 && (node = commandNode.arguments().get(0)) instanceof IdentifierNode && functionName.equals((identifierNode = (IdentifierNode)node).identifier());
    }
}

