/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.tree.impl;

import java.util.Iterator;
import java.util.List;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;

public class CompoundTextRange
extends TextRange {
    private final List<TextRange> textRanges;

    public CompoundTextRange(List<TextRange> textRanges) {
        super(textRanges.get(0).start(), textRanges.get(textRanges.size() - 1).end());
        this.textRanges = textRanges;
    }

    public TextRange computeTextRangeAtIndex(int startIndex, String token) {
        TextRangeIterator rangeIterator = new TextRangeIterator(this.textRanges.iterator());
        rangeIterator.next();
        int shift = this.navigateToRangeAtIndex(rangeIterator, startIndex);
        TextRange startRange = rangeIterator.current();
        int endIndex = shift + token.length();
        int finalIndex = this.navigateToRangeAtIndex(rangeIterator, endIndex);
        TextRange endRange = rangeIterator.current();
        int startLine = startRange.start().line();
        int startOffset = startRange.start().lineOffset() + shift;
        int endLine = endRange.end().line();
        int endOffset = finalIndex;
        if (startRange.start().line() == endRange.end().line()) {
            endOffset += startRange.start().lineOffset();
        }
        return TextRanges.range(startLine, startOffset, endLine, endOffset);
    }

    public int navigateToRangeAtIndex(TextRangeIterator iterator, int index) {
        while (index > iterator.currentRangeSize()) {
            index -= iterator.currentRangeSize() + 1;
            iterator.next();
        }
        return index;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CompoundTextRange otherRange = (CompoundTextRange)other;
        return this.textRanges.equals(otherRange.textRanges);
    }

    @Override
    public int hashCode() {
        return this.textRanges.hashCode();
    }

    static class TextRangeIterator {
        private final Iterator<TextRange> iterator;
        private TextRange current;

        public TextRangeIterator(Iterator<TextRange> iterator) {
            this.iterator = iterator;
        }

        public TextRange next() {
            this.current = this.iterator.next();
            return this.current;
        }

        public TextRange current() {
            return this.current;
        }

        public int currentRangeSize() {
            return this.current.end().lineOffset() - this.current.start().lineOffset();
        }
    }
}

