/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.docker.symbols.ArgumentResolution;
import org.sonar.iac.docker.tree.api.Argument;
import org.sonar.iac.docker.tree.api.ExposeInstruction;

@Rule(key="S6473")
public class ExposePortCheck
implements IacCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ExposePortCheck.class);
    private static final String MESSAGE = "Make sure that exposing administration services is safe here.";
    private static final String DEFAULT_SENSITIVE_PORTS = "22, 23, 3389, 5800, 5900";
    private List<Integer> sensitivePorts;
    @RuleProperty(key="ports", description="Comma separated list of sensitive ports.", defaultValue="22, 23, 3389, 5800, 5900")
    String portList = "22, 23, 3389, 5800, 5900";

    @Override
    public void initialize(InitContext init) {
        init.register(ExposeInstruction.class, (ctx, instruction) -> instruction.arguments().forEach(arg -> this.checkPort((CheckContext)ctx, (Argument)arg)));
        this.sensitivePorts = ExposePortCheck.sensitivePorts(this.portList);
    }

    private static List<Integer> sensitivePorts(String ports) {
        try {
            return Arrays.stream(ports.split(",\\s*+")).map(Integer::parseInt).toList();
        }
        catch (NumberFormatException e) {
            LOG.warn("The port list provided for ExposePortCheck (S6473) is not a comma seperated list of integers. The default list is used. Invalid list of ports \"{}\"", (Object)ports);
            return ExposePortCheck.sensitivePorts(DEFAULT_SENSITIVE_PORTS);
        }
    }

    private void checkPort(CheckContext ctx, Argument arg) {
        String portStr = ArgumentResolution.of(arg).value();
        try {
            Port port = new Port.PortParser(portStr).parsePort().parseProtocol().build();
            if (port.protocol == Protocol.TCP && this.isSensitivePort(port.portMin, port.portMax)) {
                ctx.reportIssue(arg, MESSAGE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean isSensitivePort(int min, int max) {
        return this.sensitivePorts.stream().anyMatch(sensitivePort -> ExposePortCheck.isBetween(sensitivePort, min, max));
    }

    private static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    static class Port {
        int portMin;
        int portMax;
        Protocol protocol;

        Port() {
        }

        static class PortParser {
            String[] splittedProtocol;
            Port port = new Port();

            public PortParser(String str) {
                this.splittedProtocol = str.split("/");
            }

            public PortParser parsePort() {
                String[] ports = this.splittedProtocol[0].split("-");
                this.port.portMin = Integer.parseInt(ports[0]);
                this.port.portMax = ports.length > 1 ? Integer.parseInt(ports[1]) : this.port.portMin;
                return this;
            }

            public PortParser parseProtocol() {
                this.port.protocol = this.splittedProtocol.length > 1 && this.splittedProtocol[1].equalsIgnoreCase("udp") ? Protocol.UDP : Protocol.TCP;
                return this;
            }

            public Port build() {
                return this.port;
            }
        }
    }

    static enum Protocol {
        TCP,
        UDP;

    }
}

