/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.visitors.YamlHighlightingVisitor;
import org.sonar.iac.common.yaml.visitors.YamlMetricsVisitor;

public abstract class YamlSensor
extends IacSensor {
    protected static final String JSON_LANGUAGE_KEY = "json";
    protected static final String YAML_LANGUAGE_KEY = "yaml";
    protected static final String FILE_SEPARATOR = "---";
    protected final Checks<IacCheck> checks;

    protected YamlSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, Language language, List<Class<?>> checks) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, language);
        this.checks = checkFactory.create(this.repositoryKey());
        this.checks.addAnnotatedChecks(checks);
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages(JSON_LANGUAGE_KEY, YAML_LANGUAGE_KEY).name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected TreeParser<Tree> treeParser() {
        return new YamlParser();
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add(new YamlHighlightingVisitor());
            visitors.add(new YamlMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
        }
        visitors.add(new ChecksVisitor(this.checks, statistics));
        return visitors;
    }

    @Override
    protected ParseException toParseException(String action, InputFileContext inputFileContext, Exception cause) {
        if (cause instanceof MarkedYamlEngineException) {
            MarkedYamlEngineException markedException = (MarkedYamlEngineException)cause;
            Optional<Mark> problemMark = markedException.getProblemMark();
            TextPointer position = null;
            if (problemMark.isPresent()) {
                position = inputFileContext.newPointer(problemMark.get().getLine() + 1, 0);
            }
            return ParseException.createGeneralParseException(action, inputFileContext.inputFile, cause, position);
        }
        return super.toParseException(action, inputFileContext, cause);
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        return fileSystem.predicates().and(fileSystem.predicates().and(fileSystem.predicates().or(fileSystem.predicates().hasLanguage(JSON_LANGUAGE_KEY), fileSystem.predicates().hasLanguage(YAML_LANGUAGE_KEY)), fileSystem.predicates().hasType(InputFile.Type.MAIN)), this.customFilePredicate(sensorContext));
    }

    protected abstract FilePredicate customFilePredicate(SensorContext var1);
}

