/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.HasComments;
import org.sonar.iac.common.api.tree.Tree;

@Rule(key="S1135")
public class ToDoCommentCheck
implements IacCheck {
    private static final String MESSAGE = "Complete the task associated to this \"TODO\" comment.";

    @Override
    public void initialize(InitContext context) {
        context.register(Tree.class, (ctx, tree) -> {
            if (tree instanceof HasComments) {
                HasComments treeWithComments = (HasComments)((Object)tree);
                List<Comment> comments = treeWithComments.comments();
                for (Comment comment : comments) {
                    if (!comment.value().contains("TODO")) continue;
                    ctx.reportIssue(comment.textRange(), MESSAGE);
                }
            }
        });
    }
}

