/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

public final class ResourceAccessPolicyVector {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAccessPolicyVector.class);
    private static final String VECTOR_FILE = "ResourceAccessPolicyVector.json";
    private static final List<String> RESOURCE_ACCESS_POLICIES = ResourceAccessPolicyVector.loadResourceAccessPolicies("ResourceAccessPolicyVector.json");

    private ResourceAccessPolicyVector() {
    }

    static List<String> loadResourceAccessPolicies(String filePath) {
        try {
            JsonValue value = Json.parse(ResourceAccessPolicyVector.loadJsonFile(filePath));
            return value.asArray().values().stream().map(JsonValue::asString).toList();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    static String loadJsonFile(String filePath) throws IOException {
        try (InputStream input = ResourceAccessPolicyVector.class.getClassLoader().getResourceAsStream(filePath);){
            if (input == null) {
                throw new IOException("No able to load " + filePath);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = input.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = input.read(buffer);
            }
            String string = out.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public static boolean isResourceAccessPolicy(Tree action) {
        return TextUtils.matchesValue(action, RESOURCE_ACCESS_POLICIES::contains).isTrue();
    }
}

