/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.Trilean;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Trilean has(@Nullable Tree tree, String key) {
        if (tree instanceof HasProperties) {
            HasProperties treeWithProperties = (HasProperties)((Object)tree);
            Set elementTrileans = treeWithProperties.properties().stream().map(element -> TextUtils.isValue(element.key(), key)).collect(Collectors.toSet());
            if (elementTrileans.contains((Object)Trilean.TRUE)) {
                return Trilean.TRUE;
            }
            if (elementTrileans.contains((Object)Trilean.UNKNOWN)) {
                return Trilean.UNKNOWN;
            }
        }
        return Trilean.FALSE;
    }

    public static boolean valueIs(@Nullable Tree tree, String key, Predicate<Tree> predicate) {
        return PropertyUtils.value(tree, key).filter(predicate).isPresent();
    }

    public static boolean isMissing(@Nullable Tree tree, String key) {
        return PropertyUtils.has(tree, key).isFalse();
    }

    public static Optional<PropertyTree> get(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key::equals);
    }

    public static List<PropertyTree> getAll(@Nullable Tree tree, String key) {
        return PropertyUtils.getAll(tree, key::equals).toList();
    }

    public static <T extends Tree> List<T> getAll(@Nullable Tree tree, String key, Class<T> clazz) {
        return PropertyUtils.getAll(tree, key::equals).filter(clazz::isInstance).map(clazz::cast).toList();
    }

    public static <T extends Tree> List<T> getAll(@Nullable Tree tree, Class<T> clazz) {
        return PropertyUtils.getAll(tree, (String t) -> true).filter(clazz::isInstance).map(clazz::cast).toList();
    }

    public static Optional<PropertyTree> get(@Nullable Tree tree, Predicate<String> keyMatcher) {
        return PropertyUtils.getAll(tree, keyMatcher).findFirst();
    }

    private static Stream<PropertyTree> getAll(@Nullable Tree tree, Predicate<String> keyMatcher) {
        if (!(tree instanceof HasProperties)) {
            return Stream.empty();
        }
        return ((HasProperties)((Object)tree)).properties().stream().filter(attribute -> TextUtils.matchesValue(attribute.key(), keyMatcher).isTrue());
    }

    public static <T extends Tree> Optional<T> get(@Nullable Tree tree, String key, Class<T> clazz) {
        return PropertyUtils.get(tree, key).filter(clazz::isInstance).map(clazz::cast);
    }

    public static Optional<Tree> key(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key).map(PropertyTree::key);
    }

    public static Optional<Tree> value(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key).map(PropertyTree::value);
    }

    public static Optional<Tree> value(@Nullable Tree tree, Predicate<String> keyMatcher) {
        return PropertyUtils.get(tree, keyMatcher).map(PropertyTree::value);
    }

    public static <T extends Tree> Optional<T> value(@Nullable Tree tree, String key, Class<T> clazz) {
        return PropertyUtils.value(tree, key).filter(clazz::isInstance).map(clazz::cast);
    }

    @CheckForNull
    public static Tree valueOrNull(@Nullable Tree tree, String key) {
        return PropertyUtils.valueOrNull(tree, key, Tree.class);
    }

    @CheckForNull
    public static <T extends Tree> T valueOrNull(@Nullable Tree tree, String key, Class<T> clazz) {
        return (T)((Tree)PropertyUtils.value(tree, key, clazz).orElse(null));
    }
}

