/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checkdsl;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;

public abstract class ContextualTree<S extends ContextualTree<S, T>, T extends Tree> {
    public final CheckContext ctx;
    @Nullable
    public final T tree;
    @Nullable
    public final String name;
    @Nullable
    public final ContextualTree<? extends ContextualTree<?, ?>, ? extends Tree> parent;

    protected ContextualTree(CheckContext ctx, @Nullable T tree, @Nullable String name, @Nullable ContextualTree<? extends ContextualTree<?, ?>, ? extends Tree> parent) {
        this.ctx = ctx;
        this.tree = tree;
        this.name = name;
        this.parent = parent;
    }

    public S reportIfAbsent(String message, SecondaryLocation ... secondaries) {
        return this.reportIfAbsent(message, List.of(secondaries));
    }

    public S reportIfAbsent(String message, List<SecondaryLocation> secondaries) {
        if (this.tree == null && this.parent != null) {
            this.parent.report(String.format(message, this.name), secondaries);
        }
        return (S)this;
    }

    public S report(String message, SecondaryLocation ... secondaryLocations) {
        return this.report(message, List.of(secondaryLocations));
    }

    public S report(String message, List<SecondaryLocation> secondaries) {
        HasTextRange toHighlight = this.toHighlight();
        if (toHighlight != null) {
            this.ctx.reportIssue(toHighlight, message, secondaries);
        }
        return (S)this;
    }

    @CheckForNull
    public SecondaryLocation toSecondary(String message) {
        HasTextRange toHighlight = this.toHighlight();
        if (toHighlight != null) {
            return new SecondaryLocation(toHighlight, message);
        }
        return null;
    }

    @CheckForNull
    protected HasTextRange toHighlight() {
        return this.tree;
    }

    public boolean isPresent() {
        return this.tree != null;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.tree != null) {
            action.accept(this.tree);
        }
    }

    public boolean isAbsent() {
        return this.tree == null;
    }
}

