/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.sonar.iac.common.api.tree.IacToken;
import org.sonar.iac.common.api.tree.SeparatedList;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.Tuple;

public record SeparatedListImpl<T extends Tree, U extends IacToken>(List<T> elements, List<U> separators) implements SeparatedList<T, U>
{
    private final List<U> separators;

    @Override
    public List<U> separators() {
        return this.separators.stream().filter(Objects::nonNull).toList();
    }

    @Override
    public List<Tree> elementsAndSeparators() {
        ArrayList<Tree> result = new ArrayList<Tree>();
        Iterator<T> elementsIterator = this.elements.iterator();
        Iterator<U> separatorIterator = this.separators.iterator();
        while (elementsIterator.hasNext() && separatorIterator.hasNext()) {
            result.add((Tree)elementsIterator.next());
            IacToken separator = (IacToken)separatorIterator.next();
            if (separator == null) continue;
            result.add(separator);
        }
        if (elementsIterator.hasNext()) {
            result.add((Tree)elementsIterator.next());
        }
        return result;
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> separatedList(R firstElement, Optional<List<Tuple<S, R>>> additionalElements) {
        return SeparatedListImpl.separatedList(firstElement, additionalElements.or(Collections.emptyList()));
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> separatedList(R firstElement, List<Tuple<S, R>> additionalElements) {
        ArrayList<Tree> elements = new ArrayList<Tree>();
        ArrayList<IacToken> separators = new ArrayList<IacToken>();
        elements.add(firstElement);
        for (Tuple<S, R> elementsWithSeparators : additionalElements) {
            separators.add((IacToken)elementsWithSeparators.first());
            elements.add((Tree)elementsWithSeparators.second());
        }
        return new SeparatedListImpl(elements, separators);
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> emptySeparatedList() {
        return new SeparatedListImpl(new ArrayList(), new ArrayList());
    }
}

