/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6329")
public class AssignedPublicIPAddressCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure allowing public network access is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.";
    private static final String SECONDARY_DMS_MESSAGE = "Related DMS instance";
    private static final String SECONDARY_EC2_INSTANCE_MESSAGE = "Related EC2 instance";
    private static final String SECONDARY_EC2_TEMPLATE_MESSAGE = "Related EC2 template";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::DMS::ReplicationInstance")) {
            AssignedPublicIPAddressCheck.checkDMSReplicationInstance(ctx, resource);
        } else if (resource.isType("AWS::EC2::Instance")) {
            AssignedPublicIPAddressCheck.checkEC2Instance(ctx, resource);
        } else if (resource.isType("AWS::EC2::LaunchTemplate")) {
            AssignedPublicIPAddressCheck.checkEC2LaunchTemplate(ctx, resource);
        }
    }

    private static void checkDMSReplicationInstance(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value(resource.properties(), "PubliclyAccessible", ScalarTree.class).ifPresentOrElse(publiclyAccessible -> AssignedPublicIPAddressCheck.reportIfTrue(ctx, publiclyAccessible, new SecondaryLocation(resource.type(), SECONDARY_DMS_MESSAGE)), () -> AssignedPublicIPAddressCheck.reportIfAbsent(ctx, resource, "PubliclyAccessible"));
    }

    private static void checkEC2Instance(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), "NetworkInterfaces").ifPresentOrElse(networkInterfaces -> AssignedPublicIPAddressCheck.checkNetworkInterfaces(ctx, networkInterfaces, new SecondaryLocation(resource.type(), SECONDARY_EC2_INSTANCE_MESSAGE)), () -> AssignedPublicIPAddressCheck.reportIfAbsent(ctx, resource, "NetworkInterfaces.AssociatePublicIpAddress"));
    }

    private static void checkEC2LaunchTemplate(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), "LaunchTemplateData").ifPresentOrElse(launchTemplateData -> PropertyUtils.get(launchTemplateData.value(), "NetworkInterfaces").ifPresentOrElse(networkInterfaces -> AssignedPublicIPAddressCheck.checkNetworkInterfaces(ctx, networkInterfaces, new SecondaryLocation(resource.type(), SECONDARY_EC2_TEMPLATE_MESSAGE)), () -> AssignedPublicIPAddressCheck.reportIfAbsent(ctx, launchTemplateData, "NetworkInterfaces.AssociatePublicIpAddress", resource, SECONDARY_EC2_TEMPLATE_MESSAGE)), () -> AssignedPublicIPAddressCheck.reportIfAbsent(ctx, resource, "LaunchTemplateData.NetworkInterfaces.AssociatePublicIpAddress"));
    }

    private static void checkNetworkInterfaces(CheckContext ctx, PropertyTree networkInterfaces, SecondaryLocation resourceSecondary) {
        Optional.of(networkInterfaces.value()).filter(SequenceTree.class::isInstance).map(SequenceTree.class::cast).stream().flatMap(values -> values.elements().stream()).map(element -> PropertyUtils.value((Tree)element, "AssociatePublicIpAddress")).flatMap(Optional::stream).findAny().ifPresentOrElse(associatePublicIpAddress -> AssignedPublicIPAddressCheck.reportIfTrue(ctx, associatePublicIpAddress, resourceSecondary), () -> AssignedPublicIPAddressCheck.reportIfAbsent(ctx, networkInterfaces, "AssociatePublicIpAddress", resourceSecondary));
    }

    private static void reportIfAbsent(CheckContext ctx, AbstractResourceCheck.Resource resource, String propertyName) {
        AssignedPublicIPAddressCheck.reportResource(ctx, resource, String.format(OMITTING_MESSAGE, propertyName));
    }

    private static void reportIfAbsent(CheckContext ctx, PropertyTree parent, String propertyName, AbstractResourceCheck.Resource resource, String secondaryMessage) {
        AssignedPublicIPAddressCheck.reportIfAbsent(ctx, parent, propertyName, new SecondaryLocation(resource.type(), secondaryMessage));
    }

    private static void reportIfAbsent(CheckContext ctx, PropertyTree parent, String propertyName, SecondaryLocation secondary) {
        ctx.reportIssue((HasTextRange)parent.key(), String.format(OMITTING_MESSAGE, propertyName), secondary);
    }

    private static void reportIfTrue(CheckContext ctx, Tree tree, SecondaryLocation secondary) {
        if (TextUtils.isValueTrue(tree)) {
            ctx.reportIssue((HasTextRange)tree, MESSAGE, secondary);
        }
    }
}

