/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6270")
public class AnonymousAccessPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting public access is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PolicyUtils.getPolicies(resource.properties()).forEach(policy -> AnonymousAccessPolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements(policy).forEach(statement -> ctx.reportIssue((HasTextRange)statement.principal, MESSAGE, new SecondaryLocation(statement.effect, SECONDARY_MESSAGE)));
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        static List<InsecureStatement> findInsecureStatements(Policy policy) {
            ArrayList<InsecureStatement> result = new ArrayList<InsecureStatement>();
            for (Policy.Statement statement : policy.statement()) {
                statement.effect().filter(PolicyValidator::isAllowEffect).ifPresent(effect -> statement.principal().flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(principal -> result.add(new InsecureStatement((Tree)principal, (Tree)effect))));
                statement.effect().filter(PolicyValidator::isDenyEffect).ifPresent(effect -> statement.notPrincipal().flatMap(PolicyValidator::findInsecurePrincipal).ifPresent(notPrincipal -> result.add(new InsecureStatement((Tree)notPrincipal, (Tree)effect))));
            }
            return result;
        }

        private static Optional<Tree> findInsecurePrincipal(Tree principal) {
            if (principal instanceof MappingTree) {
                MappingTree mappingTree = (MappingTree)principal;
                return PolicyValidator.findInsecurePrincipal(mappingTree);
            }
            if (principal instanceof SequenceTree) {
                SequenceTree sequenceTree = (SequenceTree)principal;
                return PolicyValidator.findInsecurePrincipal(sequenceTree);
            }
            if (PolicyValidator.applyToAnyPrincipal(principal)) {
                return Optional.of(principal);
            }
            return Optional.empty();
        }

        private static Optional<Tree> findInsecurePrincipal(MappingTree principal) {
            return principal.properties().stream().filter(prop -> PolicyValidator.isAwsPrincipal(prop.key())).map(PropertyTree::value).map(PolicyValidator::findInsecurePrincipal).filter(Optional::isPresent).map(Optional::get).findFirst();
        }

        private static Optional<Tree> findInsecurePrincipal(SequenceTree principal) {
            return principal.elements().stream().filter(PolicyValidator::applyToAnyPrincipal).map(Tree.class::cast).findFirst();
        }

        private static boolean isAwsPrincipal(Tree principal) {
            return PolicyValidator.hasTextValue(principal, "AWS");
        }

        private static boolean applyToAnyPrincipal(Tree action) {
            return PolicyValidator.hasTextValue(action, "*");
        }

        private static boolean isAllowEffect(Tree effect) {
            return PolicyValidator.hasTextValue(effect, "Allow");
        }

        private static boolean isDenyEffect(Tree effect) {
            return PolicyValidator.hasTextValue(effect, "Deny");
        }

        private static boolean hasTextValue(Tree tree, String value) {
            return TextUtils.isValue(tree, value).isTrue();
        }
    }

    private record InsecureStatement(Tree principal, Tree effect) {
    }
}

