/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public abstract class AbstractResourceCheck
implements IacCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> AbstractResourceCheck.getFileResources(tree).forEach(r -> this.checkResource((CheckContext)ctx, (Resource)r)));
    }

    public static List<Resource> getFileResources(FileTree file) {
        return file.documents().stream().flatMap(document -> PropertyUtils.value(document, "Resources", MappingTree.class).stream()).flatMap(resources -> resources.elements().stream()).filter(resource -> resource.key() instanceof ScalarTree && resource.value() instanceof MappingTree).map(resource -> Resource.fromMapping((ScalarTree)resource.key(), (MappingTree)resource.value())).filter(Objects::nonNull).toList();
    }

    protected abstract void checkResource(CheckContext var1, Resource var2);

    static boolean isS3Bucket(Resource resource) {
        return resource.isType("AWS::S3::Bucket");
    }

    protected static void reportResource(CheckContext ctx, Resource resource, String message) {
        ctx.reportIssue(resource.type, message);
    }

    public static class Resource {
        private final ScalarTree name;
        private final YamlTree type;
        private final YamlTree properties;

        Resource(ScalarTree name, YamlTree type, @Nullable YamlTree properties) {
            this.name = name;
            this.type = type;
            this.properties = properties;
        }

        @CheckForNull
        private static Resource fromMapping(ScalarTree name, MappingTree mapping) {
            return PropertyUtils.value(mapping, "Type", YamlTree.class).map(typeTree -> new Resource(name, (YamlTree)typeTree, PropertyUtils.valueOrNull(mapping, "Properties", YamlTree.class))).orElse(null);
        }

        public ScalarTree name() {
            return this.name;
        }

        public YamlTree type() {
            return this.type;
        }

        @CheckForNull
        public YamlTree properties() {
            return this.properties;
        }

        public boolean isType(String expectedType) {
            return TextUtils.getValue(this.type).orElse("null").equalsIgnoreCase(expectedType);
        }
    }
}

