/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.List;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.File;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.api.bicep.TargetScopeDeclaration;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.common.api.tree.Tree;

public class TargetScopeDeclarationImpl
extends AbstractArmTreeImpl
implements TargetScopeDeclaration {
    private final SyntaxToken keyword;
    private final SyntaxToken equals;
    private final Expression expression;

    public TargetScopeDeclarationImpl(SyntaxToken keyword, SyntaxToken equals, Expression expression) {
        this.keyword = keyword;
        this.equals = equals;
        this.expression = expression;
    }

    @Override
    public List<Tree> children() {
        return List.of(this.keyword, this.equals, this.expression);
    }

    @Override
    public Expression value() {
        return this.expression;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.TARGET_SCOPE_DECLARATION;
    }

    @Override
    public File.Scope scope() {
        if (this.expression.is(ArmTree.Kind.STRING_LITERAL)) {
            StringLiteral stringLiteral = (StringLiteral)this.expression;
            return switch (stringLiteral.value()) {
                case "managementGroup" -> File.Scope.MANAGEMENT_GROUP;
                case "resourceGroup" -> File.Scope.RESOURCE_GROUP;
                case "subscription" -> File.Scope.SUBSCRIPTION;
                case "tenant" -> File.Scope.TENANT;
                default -> File.Scope.UNKNOWN;
            };
        }
        return File.Scope.UNKNOWN;
    }

    @Override
    public SyntaxToken keyword() {
        return this.keyword;
    }
}

