/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.tree.impl.bicep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.arm.tree.ArmHelper;
import org.sonar.iac.arm.tree.api.ArmTree;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.ObjectExpression;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.api.bicep.Decorator;
import org.sonar.iac.arm.tree.api.bicep.ForExpression;
import org.sonar.iac.arm.tree.api.bicep.HasDecorators;
import org.sonar.iac.arm.tree.api.bicep.HasKeyword;
import org.sonar.iac.arm.tree.api.bicep.IfCondition;
import org.sonar.iac.arm.tree.api.bicep.InterpolatedString;
import org.sonar.iac.arm.tree.api.bicep.SyntaxToken;
import org.sonar.iac.arm.tree.impl.AbstractArmTreeImpl;
import org.sonar.iac.arm.tree.impl.bicep.StringLiteralImpl;
import org.sonar.iac.arm.tree.impl.bicep.SyntaxTokenImpl;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.TextTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.checks.TextUtils;

public class ResourceDeclarationImpl
extends AbstractArmTreeImpl
implements ResourceDeclaration,
HasDecorators,
HasKeyword {
    private final List<Decorator> decorators;
    private final SyntaxToken keyword;
    private final Identifier name;
    private final InterpolatedString typeAndVersion;
    @Nullable
    private final SyntaxToken existing;
    private final SyntaxToken equalsSign;
    private final Expression body;

    public ResourceDeclarationImpl(List<Decorator> decorators, SyntaxToken keyword, Identifier name, InterpolatedString typeAndVersion, @Nullable SyntaxToken existing, SyntaxToken equalsSign, Expression body) {
        this.decorators = decorators;
        this.keyword = keyword;
        this.name = name;
        this.typeAndVersion = typeAndVersion;
        this.existing = existing;
        this.equalsSign = equalsSign;
        this.body = body;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(this.decorators);
        children.add((Decorator)((Object)this.keyword));
        children.add((Decorator)((Object)this.name));
        children.add((Decorator)((Object)this.typeAndVersion));
        ArmHelper.addChildrenIfPresent(children, this.existing);
        children.add(this.equalsSign);
        children.add(this.body);
        return children;
    }

    @Override
    public ArmTree.Kind getKind() {
        return ArmTree.Kind.RESOURCE_DECLARATION;
    }

    @Override
    @CheckForNull
    public StringLiteral name() {
        return this.resourceProperties().stream().filter(prop -> TextUtils.isValue(prop.key(), "name").isTrue()).filter(prop -> prop.value().is(ArmTree.Kind.STRING_LITERAL)).findFirst().map(prop -> (StringLiteral)prop.value()).orElse(null);
    }

    @Override
    @CheckForNull
    public Identifier symbolicName() {
        return this.name;
    }

    @Override
    @CheckForNull
    public TextTree version() {
        String[] split;
        String text = TextUtils.getValue(this.typeAndVersion).orElse("");
        if (text.contains("@") && (split = text.split("@")).length == 2) {
            int indexOfAt = text.indexOf("@");
            String version = split[1];
            TextRange typeAndVersionRange = this.typeAndVersion.textRange();
            TextRange tokenRange = TextRanges.range(typeAndVersionRange.start().line(), typeAndVersionRange.start().lineOffset() + indexOfAt + 1, typeAndVersionRange.end().line(), typeAndVersionRange.start().lineOffset() + indexOfAt + 1 + version.length());
            SyntaxTokenImpl token = new SyntaxTokenImpl(version, tokenRange, List.of());
            return new TypeOrVersionTreeImpl(token);
        }
        return null;
    }

    @Override
    public TextTree type() {
        String[] split;
        String text = TextUtils.getValue(this.typeAndVersion).orElse("");
        if (text.contains("@") && (split = text.split("@")).length == 2) {
            String type = split[0];
            TextRange typeAndVersionRange = this.typeAndVersion.textRange();
            TextRange tokenRange = TextRanges.range(typeAndVersionRange.start().line(), typeAndVersionRange.start().lineOffset() + 1, typeAndVersionRange.end().line(), typeAndVersionRange.start().lineOffset() + type.length() + 1);
            SyntaxTokenImpl token = new SyntaxTokenImpl(type, tokenRange, List.of());
            return new TypeOrVersionTreeImpl(token);
        }
        return this.typeAndVersion;
    }

    @Override
    public List<Property> properties() {
        return this.getObjectBody().map(objectBody -> ResourceDeclarationImpl.propertiesOrEmpty(objectBody.properties())).orElse(Collections.emptyList());
    }

    private Optional<ObjectExpression> getObjectBody() {
        ObjectExpression objectBody = null;
        if (this.body.is(ArmTree.Kind.OBJECT_EXPRESSION)) {
            objectBody = (ObjectExpression)this.body;
        } else if (this.body.is(ArmTree.Kind.IF_CONDITION)) {
            objectBody = ((IfCondition)this.body).object();
        } else {
            Expression bodyExpression = ((ForExpression)this.body).bodyExpression();
            if (bodyExpression.is(ArmTree.Kind.OBJECT_EXPRESSION)) {
                objectBody = (ObjectExpression)bodyExpression;
            }
        }
        return Optional.ofNullable(objectBody);
    }

    @Override
    public List<ResourceDeclaration> childResources() {
        return this.getObjectBody().map(ObjectExpression::nestedResources).orElse(Collections.emptyList());
    }

    @Override
    @CheckForNull
    public SyntaxToken existing() {
        return this.existing;
    }

    @Override
    public List<Property> resourceProperties() {
        return this.getObjectBody().map(b -> b.properties().stream().map(Property.class::cast).toList()).orElse(List.of());
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public SyntaxToken keyword() {
        return this.keyword;
    }

    private static List<Property> propertiesOrEmpty(List<PropertyTree> properties) {
        return properties.stream().filter(propertyTree -> "properties".equals(((TextTree)propertyTree.key()).value())).filter(propertyTree -> ((Property)propertyTree).value().is(ArmTree.Kind.OBJECT_EXPRESSION)).map(p -> Collections.unmodifiableList(((ObjectExpression)((Property)p).value()).properties())).findFirst().orElse(List.of());
    }

    static class TypeOrVersionTreeImpl
    extends StringLiteralImpl {
        public TypeOrVersionTreeImpl(SyntaxToken token) {
            super(token);
        }

        @Override
        public String value() {
            return this.token.value();
        }
    }
}

