/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.plugin;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.arm.checks.ArmCheckList;
import org.sonar.iac.arm.parser.ArmParser;
import org.sonar.iac.arm.plugin.ArmLanguage;
import org.sonar.iac.arm.plugin.ArmMetricsVisitor;
import org.sonar.iac.arm.visitors.ArmHighlightingVisitor;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.FileIdentificationPredicate;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.yaml.YamlSensor;

public class ArmSensor
extends YamlSensor {
    public ArmSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, ArmLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, language, ArmCheckList.checks());
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguages("json", this.language.getKey()).processesFilesIndependently().name("IaC " + this.language.getName() + " Sensor");
    }

    @Override
    protected String repositoryKey() {
        return "azureresourcemanager";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.azureresourcemanager.activate";
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicates predicates = fileSystem.predicates();
        return predicates.and(predicates.hasType(InputFile.Type.MAIN), predicates.or(predicates.hasLanguage("azureresourcemanager"), predicates.and(predicates.hasLanguage("json"), this.customFilePredicate(sensorContext))));
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new FileIdentificationPredicate(sensorContext.config().get("sonar.azureresourcemanager.file.identifier").orElse(""));
    }

    @Override
    protected TreeParser<Tree> treeParser() {
        return new ArmParser();
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        visitors.add(new ChecksVisitor(this.checks, statistics));
        if (this.isNotSonarLintContext(sensorContext)) {
            visitors.add(new ArmMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
            visitors.add(new ArmHighlightingVisitor());
        }
        return visitors;
    }

    public static boolean isBicepFile(InputFileContext inputFileContext) {
        return "azureresourcemanager".equals(inputFileContext.inputFile.language());
    }
}

