/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.arm.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.arm.parser.ArmJsonBaseConverter;
import org.sonar.iac.arm.tree.api.Expression;
import org.sonar.iac.arm.tree.api.Identifier;
import org.sonar.iac.arm.tree.api.Property;
import org.sonar.iac.arm.tree.api.ResourceDeclaration;
import org.sonar.iac.arm.tree.api.StringLiteral;
import org.sonar.iac.arm.tree.impl.json.PropertyImpl;
import org.sonar.iac.arm.tree.impl.json.ResourceDeclarationImpl;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class ResourceDeclarationConverter
extends ArmJsonBaseConverter {
    public ResourceDeclarationConverter(@Nullable InputFileContext inputFileContext) {
        super(inputFileContext);
    }

    public Stream<MappingTree> extractResourcesSequence(MappingTree document) {
        return document.elements().stream().filter(this.filterOnField("resources")).map(TupleTree::value).filter(SequenceTree.class::isInstance).map(SequenceTree.class::cast).map(sequenceTree -> ResourceDeclarationConverter.mappingTreeOnly(sequenceTree.elements())).flatMap(Collection::stream);
    }

    private static List<MappingTree> mappingTreeOnly(List<YamlTree> yamlTrees) {
        return yamlTrees.stream().filter(MappingTree.class::isInstance).map(MappingTree.class::cast).toList();
    }

    public ResourceDeclaration convertToResourceDeclaration(MappingTree tree) {
        StringLiteral type = this.toStringLiteralOrException(tree, "type");
        StringLiteral version = this.toStringLiteralOrException(tree, "apiVersion");
        StringLiteral name = this.toStringLiteralOrException(tree, "name");
        List<Property> resourceProperties = this.toResourceProperties(tree);
        List otherProperties = PropertyUtils.get((Tree)tree, "properties"::equalsIgnoreCase).map(PropertyTree::value).map(this::toProperties).orElse(Collections.emptyList());
        return PropertyUtils.get((Tree)tree, "resources").map(childResources -> this.toResourceDeclarationWithChildren(type, version, name, otherProperties, resourceProperties, (PropertyTree)childResources)).orElseGet(() -> ResourceDeclarationConverter.toResourceDeclaration(type, version, name, otherProperties, resourceProperties));
    }

    private List<Property> toResourceProperties(MappingTree tree) {
        return tree.elements().stream().map(tupleTree -> {
            Identifier key = this.toIdentifier(tupleTree.key());
            Expression value = this.toExpression(tupleTree.value());
            return new PropertyImpl(key, value);
        }).collect(Collectors.toList());
    }

    private static ResourceDeclaration toResourceDeclaration(StringLiteral type, StringLiteral version, StringLiteral name, List<Property> otherProperties, List<Property> resourceProperties) {
        return new ResourceDeclarationImpl(name, version, type, otherProperties, resourceProperties, Collections.emptyList());
    }

    private ResourceDeclaration toResourceDeclarationWithChildren(StringLiteral type, StringLiteral version, StringLiteral name, List<Property> otherProperties, List<Property> resourceProperties, PropertyTree childResourcesProperty) {
        List<ResourceDeclaration> childResources = Optional.of(childResourcesProperty.value()).filter(SequenceTree.class::isInstance).map(SequenceTree.class::cast).map(sequenceTree -> ResourceDeclarationConverter.mappingTreeOnly(sequenceTree.elements())).map(m -> m.stream().map(this::convertToResourceDeclaration).toList()).orElse(Collections.emptyList());
        return new ResourceDeclarationImpl(name, version, type, otherProperties, resourceProperties, childResources);
    }
}

